"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendEmailsToBatch = exports.sendBroadcastEmails = exports.processBroadcastMailsRequest = exports.fetchUsersInBatches = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _puppeteer = _interopRequireDefault(require("puppeteer"));
var _mailer = _interopRequireDefault(require("../mailer"));
var _upload_file = _interopRequireDefault(require("../Content/upload_file"));
var _path = _interopRequireDefault(require("path"));
var _fs = _interopRequireDefault(require("fs"));
var browser;
function getBrowserInstance() {
  return _getBrowserInstance.apply(this, arguments);
} // async function captureScreenshotToFile(htmlContent, filePath) {
//   try {
//     const browser = await getBrowserInstance();
//     const page = await browser.newPage();
//     await page.setContent(htmlContent);
//     await page.screenshot({ path: filePath });
//     await page.close();
//     return filePath;
//   } catch (error) {
//     console.error("Error capturing screenshot: ", error);
//     throw error;
//   }
// }
function _getBrowserInstance() {
  _getBrowserInstance = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee6() {
    return _regenerator["default"].wrap(function _callee6$(_context6) {
      while (1) switch (_context6.prev = _context6.next) {
        case 0:
          _context6.prev = 0;
          if (browser) {
            _context6.next = 5;
            break;
          }
          _context6.next = 4;
          return _puppeteer["default"].launch({
            args: ['--no-sandbox', '--disable-setuid-sandbox'],
            headless: true
          });
        case 4:
          browser = _context6.sent;
        case 5:
          return _context6.abrupt("return", browser);
        case 8:
          _context6.prev = 8;
          _context6.t0 = _context6["catch"](0);
          throw _context6.t0;
        case 11:
        case "end":
          return _context6.stop();
      }
    }, _callee6, null, [[0, 8]]);
  }));
  return _getBrowserInstance.apply(this, arguments);
}
function captureScreenshotToFile(_x, _x2) {
  return _captureScreenshotToFile.apply(this, arguments);
}
function _captureScreenshotToFile() {
  _captureScreenshotToFile = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee7(htmlContent, filePath) {
    var browser, page;
    return _regenerator["default"].wrap(function _callee7$(_context7) {
      while (1) switch (_context7.prev = _context7.next) {
        case 0:
          _context7.prev = 0;
          _context7.next = 3;
          return _puppeteer["default"].launch({
            args: ['--no-sandbox', '--disable-setuid-sandbox'],
            headless: true
          });
        case 3:
          browser = _context7.sent;
          _context7.next = 6;
          return browser.newPage();
        case 6:
          page = _context7.sent;
          _context7.next = 9;
          return page.setContent(htmlContent);
        case 9:
          _context7.next = 11;
          return page.screenshot({
            path: filePath
          });
        case 11:
          _context7.next = 13;
          return page.close();
        case 13:
          return _context7.abrupt("return", filePath);
        case 16:
          _context7.prev = 16;
          _context7.t0 = _context7["catch"](0);
          console.error("Error capturing screenshot: ", _context7.t0);
          throw _context7.t0;
        case 20:
          _context7.prev = 20;
          if (!browser) {
            _context7.next = 24;
            break;
          }
          _context7.next = 24;
          return browser.close();
        case 24:
          return _context7.finish(20);
        case 25:
        case "end":
          return _context7.stop();
      }
    }, _callee7, null, [[0, 16, 20, 25]]);
  }));
  return _captureScreenshotToFile.apply(this, arguments);
}
var fetchUsersInBatches = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(batchSize, companyId) {
    var lastId,
      query,
      batch,
      _args = arguments;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          lastId = _args.length > 2 && _args[2] !== undefined ? _args[2] : null;
          _context.prev = 1;
          query = lastId ? {
            _id: {
              $gt: lastId
            },
            companyId: companyId,
            isActive: true,
            deletedAt: null
          } : {
            companyId: companyId,
            isActive: true,
            deletedAt: null
          };
          _context.next = 5;
          return db.User.find(query).limit(batchSize).sort({
            _id: 1
          });
        case 5:
          batch = _context.sent;
          return _context.abrupt("return", batch);
        case 9:
          _context.prev = 9;
          _context.t0 = _context["catch"](1);
          throw _context.t0;
        case 12:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[1, 9]]);
  }));
  return function fetchUsersInBatches(_x3, _x4) {
    return _ref.apply(this, arguments);
  };
}();
exports.fetchUsersInBatches = fetchUsersInBatches;
var sendEmailsToBatch = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(reportedMail, userBatch, screenshotFilePath, mailId) {
    var reporterEmails, to, MailAlreadySent;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          reporterEmails = reportedMail.reporters.map(function (reporter) {
            return reporter.email;
          });
          to = userBatch.map(function (user) {
            return user.email;
          }).join(', ');
          _context2.next = 5;
          return db.ReportedMail.findOne({
            mailId: mailId
          });
        case 5:
          MailAlreadySent = _context2.sent;
          MailAlreadySent = MailAlreadySent.isBroadcastMail;
          if (!(to && !MailAlreadySent)) {
            _context2.next = 12;
            break;
          }
          _context2.next = 10;
          return db.ReportedMail.updateOne({
            mailId: mailId
          }, {
            $set: {
              isBroadcastMail: true
            }
          });
        case 10:
          _context2.next = 12;
          return _mailer["default"].sendBroadcastMail(reportedMail.from, reportedMail.subject, reportedMail.companyId, to, screenshotFilePath, mailId);
        case 12:
          _context2.next = 17;
          break;
        case 14:
          _context2.prev = 14;
          _context2.t0 = _context2["catch"](0);
          throw _context2.t0;
        case 17:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 14]]);
  }));
  return function sendEmailsToBatch(_x5, _x6, _x7, _x8) {
    return _ref2.apply(this, arguments);
  };
}();
exports.sendEmailsToBatch = sendEmailsToBatch;
var sendBroadcastEmails = /*#__PURE__*/function () {
  var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(reportedMailIds, companyId) {
    var batchSize, users, emailPromises;
    return _regenerator["default"].wrap(function _callee4$(_context4) {
      while (1) switch (_context4.prev = _context4.next) {
        case 0:
          _context4.prev = 0;
          batchSize = 1000;
          _context4.next = 4;
          return fetchUsersInBatches(batchSize, companyId);
        case 4:
          users = _context4.sent;
          emailPromises = reportedMailIds.map( /*#__PURE__*/function () {
            var _ref4 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(mailId) {
              var reportedMail, screenshotFilePath, batchPromises, lastId, userBatch;
              return _regenerator["default"].wrap(function _callee3$(_context3) {
                while (1) switch (_context3.prev = _context3.next) {
                  case 0:
                    _context3.next = 2;
                    return _upload_file["default"].fetchReportedMail(mailId);
                  case 2:
                    reportedMail = _context3.sent;
                    if (reportedMail) {
                      _context3.next = 6;
                      break;
                    }
                    console.error("Reported mail with ID ".concat(mailId, " not found"));
                    return _context3.abrupt("return");
                  case 6:
                    screenshotFilePath = _path["default"].join(appRoot, 'Content', 'reportedMailScreenshots', "screenshot-".concat(mailId, ".png"));
                    console.log('Before capturing screenshot', reportedMail.body);
                    _context3.next = 10;
                    return captureScreenshotToFile(reportedMail.body, screenshotFilePath);
                  case 10:
                    batchPromises = [];
                    lastId = null;
                  case 12:
                    if (!true) {
                      _context3.next = 23;
                      break;
                    }
                    console.log('Fetching user batches...');
                    _context3.next = 16;
                    return fetchUsersInBatches(batchSize, companyId, lastId);
                  case 16:
                    userBatch = _context3.sent;
                    if (!(userBatch.length === 0)) {
                      _context3.next = 19;
                      break;
                    }
                    return _context3.abrupt("break", 23);
                  case 19:
                    batchPromises.push(sendEmailsToBatch(reportedMail, userBatch, screenshotFilePath, reportedMail.mailId));
                    lastId = userBatch[userBatch.length - 1]._id;
                    _context3.next = 12;
                    break;
                  case 23:
                    _context3.next = 25;
                    return Promise.all(batchPromises);
                  case 25:
                    _fs["default"].unlink(screenshotFilePath, function (err) {
                      if (err) {
                        console.error("Error deleting screenshot file: ".concat(screenshotFilePath), err);
                      } else {
                        console.log("Deleted screenshot file: ".concat(screenshotFilePath));
                      }
                    });
                  case 26:
                  case "end":
                    return _context3.stop();
                }
              }, _callee3);
            }));
            return function (_x11) {
              return _ref4.apply(this, arguments);
            };
          }());
          _context4.next = 8;
          return Promise.all(emailPromises);
        case 8:
          _context4.next = 15;
          break;
        case 10:
          _context4.prev = 10;
          _context4.t0 = _context4["catch"](0);
          _context4.next = 14;
          return db.ReportedMail.updateOne({
            mailId: reportedMailIds[0]
          }, {
            $set: {
              isBroadcastMail: false
            }
          });
        case 14:
          throw _context4.t0;
        case 15:
        case "end":
          return _context4.stop();
      }
    }, _callee4, null, [[0, 10]]);
  }));
  return function sendBroadcastEmails(_x9, _x10) {
    return _ref3.apply(this, arguments);
  };
}();
exports.sendBroadcastEmails = sendBroadcastEmails;
var processBroadcastMailsRequest = /*#__PURE__*/function () {
  var _ref5 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee5(reportedMailIds, companyId) {
    return _regenerator["default"].wrap(function _callee5$(_context5) {
      while (1) switch (_context5.prev = _context5.next) {
        case 0:
          return _context5.abrupt("return", sendBroadcastEmails(reportedMailIds, companyId));
        case 1:
        case "end":
          return _context5.stop();
      }
    }, _callee5);
  }));
  return function processBroadcastMailsRequest(_x12, _x13) {
    return _ref5.apply(this, arguments);
  };
}();
exports.processBroadcastMailsRequest = processBroadcastMailsRequest;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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