"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromGsuite = exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _googleapis = require("googleapis");
var _crypto = _interopRequireDefault(require("../crypto"));
var _getOutlookToken = _interopRequireDefault(require("./get-outlook-token"));
var fromOutlook = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(credential) {
    var tenantId, clientId, clientSecret, token;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          tenantId = _crypto["default"].decrypt(credential['tenantId']);
          clientId = _crypto["default"].decrypt(credential['clientId']);
          clientSecret = _crypto["default"].decrypt(credential['clientSecret']);
          _context.next = 6;
          return _getOutlookToken["default"].getOutlookAuthToken(tenantId, clientId, clientSecret);
        case 6:
          token = _context.sent;
          return _context.abrupt("return", {
            token: token
          });
        case 10:
          _context.prev = 10;
          _context.t0 = _context["catch"](0);
          throw new RequestError('Invalid credentials', 429);
        case 13:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 10]]);
  }));
  return function fromOutlook(_x) {
    return _ref.apply(this, arguments);
  };
}();
var fromGsuite = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(credential) {
    var adminEmail, fileName, credentialFilePath, authClient, service;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          adminEmail = credential.adminEmail, fileName = credential.fileName;
          credentialFilePath = _path["default"].join(appRoot, 'Content', 'Credentials', fileName);
          if (!_fs["default"].existsSync(credentialFilePath)) {
            _context2.next = 11;
            break;
          }
          authClient = new _googleapis.google.auth.JWT({
            keyFile: credentialFilePath,
            scopes: ['https://mail.google.com/', 'https://www.googleapis.com/auth/admin.directory.user', 'https://www.googleapis.com/auth/admin.directory.group.readonly'],
            subject: adminEmail
          });
          _context2.next = 7;
          return authClient.authorize();
        case 7:
          service = _googleapis.google.admin({
            version: 'directory_v1',
            auth: authClient
          });
          return _context2.abrupt("return", {
            service: service,
            fileName: fileName
          });
        case 11:
          throw new Error('Credential file not exists', 429);
        case 12:
          _context2.next = 18;
          break;
        case 14:
          _context2.prev = 14;
          _context2.t0 = _context2["catch"](0);
          console.log(_context2.t0);
          throw new RequestError("Invalid Credentials.", 429);
        case 18:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 14]]);
  }));
  return function fromGsuite(_x2) {
    return _ref2.apply(this, arguments);
  };
}();
exports.fromGsuite = fromGsuite;
var _default = {
  getCredentials: function () {
    var _getCredentials = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(companyId, domainId) {
      var domain;
      return _regenerator["default"].wrap(function _callee3$(_context3) {
        while (1) switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return db.Domain.findOne({
              _id: domainId,
              companyId: companyId,
              deletedAt: null
            });
          case 2:
            domain = _context3.sent;
            if (!domain) {
              _context3.next = 11;
              break;
            }
            if (!(domain.domainType == 'Gsuite')) {
              _context3.next = 8;
              break;
            }
            return _context3.abrupt("return", fromGsuite(domain.credential));
          case 8:
            return _context3.abrupt("return", fromOutlook(domain.credential));
          case 9:
            _context3.next = 12;
            break;
          case 11:
            return _context3.abrupt("return", new RequestError('Invalid domain credentials', 429));
          case 12:
          case "end":
            return _context3.stop();
        }
      }, _callee3);
    }));
    function getCredentials(_x3, _x4) {
      return _getCredentials.apply(this, arguments);
    }
    return getCredentials;
  }()
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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