"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _mongoose = _interopRequireDefault(require("mongoose"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var getTopReportersData = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(condition) {
    var count, toCounts, reporterCounts, emailCounts, addCounts, mergedArray, emails, users, userMap, result;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.next = 2;
          return db.ReportedMail.countDocuments(condition);
        case 2:
          count = _context.sent;
          _context.next = 5;
          return db.ReportedMail.aggregate([{
            $match: condition
          }, {
            $group: {
              _id: "$to",
              count: {
                $sum: 1
              }
            }
          }]);
        case 5:
          toCounts = _context.sent;
          _context.next = 8;
          return db.ReportedMail.aggregate([{
            $match: condition
          }, {
            $unwind: "$reporters"
          }, {
            $group: {
              _id: "$reporters.email",
              count: {
                $sum: 1
              }
            }
          }]);
        case 8:
          reporterCounts = _context.sent;
          emailCounts = {};
          addCounts = function addCounts(array) {
            array.forEach(function (_ref2) {
              var _id = _ref2._id,
                count = _ref2.count;
              var normalizedEmail = _id.toLowerCase();
              emailCounts[normalizedEmail] = (emailCounts[normalizedEmail] || 0) + count;
            });
          };
          addCounts(toCounts);
          addCounts(reporterCounts);
          mergedArray = Object.entries(emailCounts).map(function (_ref3) {
            var _ref4 = (0, _slicedToArray2["default"])(_ref3, 2),
              email = _ref4[0],
              count = _ref4[1];
            return {
              email: email,
              count: count
            };
          }).sort(function (a, b) {
            return b.count - a.count;
          }).slice(0, 5);
          emails = mergedArray.map(function (_ref5) {
            var email = _ref5.email;
            return email;
          });
          _context.next = 17;
          return db.User.find({
            email: {
              $in: emails
            },
            companyId: condition.companyId
          }).select('name email').lean();
        case 17:
          users = _context.sent;
          userMap = users.reduce(function (acc, user) {
            acc[user.email] = user.name || 'Unknown';
            return acc;
          }, {});
          result = mergedArray.map(function (_ref6) {
            var email = _ref6.email,
              count = _ref6.count;
            return {
              name: userMap[email] || 'Unknown',
              email: email,
              count: count
            };
          });
          return _context.abrupt("return", {
            data: result,
            count: count,
            label: 'Email Reporting',
            type: "TableListingType1"
          });
        case 21:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return function getTopReportersData(_x) {
    return _ref.apply(this, arguments);
  };
}();
var getHighestReportedEmails = /*#__PURE__*/function () {
  var _ref7 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(condition) {
    var highestReportedEmails;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.next = 2;
          return db.ReportedMail.aggregate([{
            $match: condition
          }, {
            $addFields: {
              totalReporters: {
                $size: "$reporters"
              }
            }
          }, {
            $sort: {
              totalReporters: -1
            }
          }, {
            $limit: 5
          }, {
            $project: {
              _id: 1,
              totalReporters: 1,
              subject: 1,
              isDeletedEmail: 1,
              isTrashedEmail: 1,
              isRecoveredEmail: 1,
              createdAt: 1,
              from: 1,
              fromName: 1
            }
          }]);
        case 2:
          highestReportedEmails = _context2.sent;
          return _context2.abrupt("return", {
            data: highestReportedEmails,
            label: 'Email Reporting',
            type: "TPIRTableListingType1"
          });
        case 4:
        case "end":
          return _context2.stop();
      }
    }, _callee2);
  }));
  return function getHighestReportedEmails(_x2) {
    return _ref7.apply(this, arguments);
  };
}();
var getTopSenders = /*#__PURE__*/function () {
  var _ref8 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(condition) {
    var senders;
    return _regenerator["default"].wrap(function _callee3$(_context3) {
      while (1) switch (_context3.prev = _context3.next) {
        case 0:
          condition = _objectSpread(_objectSpread({}, condition), {}, {
            isDeletedEmail: "true"
          });
          _context3.next = 3;
          return db.ReportedMail.aggregate([{
            $match: condition
          }, {
            $lookup: {
              from: "whoelses",
              localField: "_id",
              foreignField: "reportedMailId",
              as: "whoElseDocuments"
            }
          }, {
            $group: {
              name: {
                "$first": "$fromName"
              },
              _id: "$from",
              reportedMailCount: {
                $sum: 1
              },
              whoElseCount: {
                $sum: {
                  $size: "$whoElseDocuments"
                }
              }
            }
          }, {
            $sort: {
              reportedMailCount: -1 // Sort in descending order
            }
          }, {
            $limit: 5
          }]);
        case 3:
          senders = _context3.sent;
          return _context3.abrupt("return", {
            data: senders,
            label: "Email Reporting",
            type: "TPIRTableListingType4"
          });
        case 5:
        case "end":
          return _context3.stop();
      }
    }, _callee3);
  }));
  return function getTopSenders(_x3) {
    return _ref8.apply(this, arguments);
  };
}();
var getTopVulnerableAttachments = /*#__PURE__*/function () {
  var _ref9 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(condition) {
    var topAttachments;
    return _regenerator["default"].wrap(function _callee4$(_context4) {
      while (1) switch (_context4.prev = _context4.next) {
        case 0:
          _context4.next = 2;
          return db.Attachment.find(_objectSpread(_objectSpread({}, condition), {}, {
            score: {
              $gte: 1
            }
          })).select("originalName score fileName").populate({
            path: "reportedMailId",
            select: "from fromName companyId"
          }).sort({
            score: -1
          }).limit(5);
        case 2:
          topAttachments = _context4.sent;
          return _context4.abrupt("return", {
            data: topAttachments,
            label: "Email Reporting",
            type: "TPIRTableListingType3"
          });
        case 4:
        case "end":
          return _context4.stop();
      }
    }, _callee4);
  }));
  return function getTopVulnerableAttachments(_x4) {
    return _ref9.apply(this, arguments);
  };
}();
var getTopVulnerableLinks = /*#__PURE__*/function () {
  var _ref10 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee5(condition) {
    var topLinks;
    return _regenerator["default"].wrap(function _callee5$(_context5) {
      while (1) switch (_context5.prev = _context5.next) {
        case 0:
          _context5.next = 2;
          return db.Url.find(_objectSpread(_objectSpread({}, condition), {}, {
            score: {
              $gte: 1
            }
          })).populate({
            path: "reportedMailId",
            select: "from fromName companyId"
          }).select("url score companyId").sort({
            score: -1
          }).limit(5);
        case 2:
          topLinks = _context5.sent;
          console.log({
            topLinks: topLinks
          });
          return _context5.abrupt("return", {
            data: topLinks,
            label: "Email Reporting",
            type: "TPIRTableListingType2"
          });
        case 5:
        case "end":
          return _context5.stop();
      }
    }, _callee5);
  }));
  return function getTopVulnerableLinks(_x5) {
    return _ref10.apply(this, arguments);
  };
}();
var getDailyReportedMails = /*#__PURE__*/function () {
  var _ref11 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee6(condition) {
    var reportedEmails, result;
    return _regenerator["default"].wrap(function _callee6$(_context6) {
      while (1) switch (_context6.prev = _context6.next) {
        case 0:
          _context6.next = 2;
          return db.ReportedMail.aggregate([{
            $match: condition
          }, {
            $group: {
              _id: {
                $dateToString: {
                  format: "%Y-%m-%d",
                  date: "$createdAt"
                }
              },
              count: {
                $sum: 1
              }
            }
          }, {
            $project: {
              createdAt: '$_id',
              count: 1,
              _id: 0
            }
          }, {
            $sort: {
              createdAt: 1
            }
          }]);
        case 2:
          reportedEmails = _context6.sent;
          result = reportedEmails.map(function (mail) {
            var unixTimestamp = new Date(mail.createdAt).getTime();
            return [unixTimestamp, mail.count];
          });
          return _context6.abrupt("return", {
            data: result,
            label: 'Email Reporting',
            type: "AreaChart"
          });
        case 5:
        case "end":
          return _context6.stop();
      }
    }, _callee6);
  }));
  return function getDailyReportedMails(_x6) {
    return _ref11.apply(this, arguments);
  };
}();
var graphHandlers = {
  RETPIR1: getTopReportersData,
  RETPIR2: getHighestReportedEmails,
  RETPIR3: getTopVulnerableLinks,
  RETPIR4: getTopVulnerableAttachments,
  RETPIR5: getTopSenders,
  RETPIR6: getDailyReportedMails
};
var getGraphData = /*#__PURE__*/function () {
  var _ref12 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee7(graphCode, params) {
    var handler;
    return _regenerator["default"].wrap(function _callee7$(_context7) {
      while (1) switch (_context7.prev = _context7.next) {
        case 0:
          handler = graphHandlers[graphCode];
          if (handler) {
            _context7.next = 3;
            break;
          }
          throw new Error("No handler found for graphCode: ".concat(graphCode));
        case 3:
          return _context7.abrupt("return", handler(params));
        case 4:
        case "end":
          return _context7.stop();
      }
    }, _callee7);
  }));
  return function getGraphData(_x7, _x8) {
    return _ref12.apply(this, arguments);
  };
}();
var _default = getGraphData;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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