"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decryptRequest = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _cryptoJs = _interopRequireDefault(require("crypto-js"));
var _config = _interopRequireDefault(require("../config"));
var includedRoutes = ['/admin/change-password', '/admin/login', '/admin/register', '/admin/reset-password', '/settings/updateSmtp', '/settings/virus-total', '/domain/domain-credential-outlook', '/domain/domain-credential-gsuite'];
var decryptRequest = function decryptRequest(req, res, next) {
  if (req.method === 'OPTIONS') {
    return next();
  }
  console.log("Request Body", req.body);
  if (includedRoutes.includes(req.path)) {
    if (req.method === 'POST' && req.body && (0, _typeof2["default"])(req.body) === 'object') {
      try {
        req.body = Object.fromEntries(Object.entries(req.body).map(function (_ref) {
          var _ref2 = (0, _slicedToArray2["default"])(_ref, 2),
            key = _ref2[0],
            value = _ref2[1];
          var bytes = _cryptoJs["default"].AES.decrypt(value, _config["default"].crypto.secret);
          return [key, JSON.parse(bytes.toString(_cryptoJs["default"].enc.Utf8))];
        }));
      } catch (error) {
        console.error('Decryption failed:', error.message);
        return res.status(400).json({
          error: 'Invalid encrypted payload'
        });
      }
    }
  }
  next();
};
exports.decryptRequest = decryptRequest;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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