"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var getGroups = function getGroups(credential, partialGroupName) {
  return new Promise(function (resolve, reject) {
    try {
      var service = credential.service;
      var sanitizedGroupName = partialGroupName === null || partialGroupName === void 0 ? void 0 : partialGroupName.trim().replace(/\s+/g, '+');
      service.groups.list(_objectSpread({
        customer: 'my_customer',
        orderBy: 'email',
        fields: 'groups(id,name)'
      }, partialGroupName && {
        query: "name:".concat(sanitizedGroupName, "*")
      }), function (err, res) {
        if (err) {
          console.error('The API returned an error:', err.message);
          reject(err);
        } else {
          var _res$data$groups, _res$data;
          var groups = (_res$data$groups = res === null || res === void 0 ? void 0 : (_res$data = res.data) === null || _res$data === void 0 ? void 0 : _res$data.groups) !== null && _res$data$groups !== void 0 ? _res$data$groups : [];
          resolve(groups);
        }
      });
    } catch (err) {
      console.error(err);
      reject(err);
    }
  });
};
var _default = {
  processGroups: function () {
    var _processGroups = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(creds, partialGroupName) {
      return _regenerator["default"].wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            return _context.abrupt("return", getGroups(creds, partialGroupName));
          case 1:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    function processGroups(_x, _x2) {
      return _processGroups.apply(this, arguments);
    }
    return processGroups;
  }()
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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