"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _kue = require("../kue");
var _updateSyncingStatusGroups = require("./update-syncing-status-groups");
var getGsuiteUsers = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(_ref) {
    var emails, service, users;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          emails = _ref.emails, service = _ref.service;
          users = [];
          _context2.next = 4;
          return Promise.allSettled(emails.map( /*#__PURE__*/function () {
            var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(email) {
              var user;
              return _regenerator["default"].wrap(function _callee$(_context) {
                while (1) switch (_context.prev = _context.next) {
                  case 0:
                    _context.prev = 0;
                    _context.next = 3;
                    return service.users.get({
                      userKey: email
                    });
                  case 3:
                    user = _context.sent;
                    users.push(user.data);
                    _context.next = 10;
                    break;
                  case 7:
                    _context.prev = 7;
                    _context.t0 = _context["catch"](0);
                    users[email] = _context.t0;
                  case 10:
                  case "end":
                    return _context.stop();
                }
              }, _callee, null, [[0, 7]]);
            }));
            return function (_x2) {
              return _ref3.apply(this, arguments);
            };
          }()));
        case 4:
          return _context2.abrupt("return", users);
        case 5:
        case "end":
          return _context2.stop();
      }
    }, _callee2);
  }));
  return function getGsuiteUsers(_x) {
    return _ref2.apply(this, arguments);
  };
}();
var getUsers = /*#__PURE__*/function () {
  var _ref4 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee7(domainId, domainName, subDomainGroups, companyId, credential) {
    var NextPageToken,
      grp,
      isMirrorSync,
      allUsersGroupId,
      syncTs,
      pageIndex,
      service,
      _args7 = arguments;
    return _regenerator["default"].wrap(function _callee7$(_context7) {
      while (1) switch (_context7.prev = _context7.next) {
        case 0:
          NextPageToken = _args7.length > 5 && _args7[5] !== undefined ? _args7[5] : null;
          grp = _args7.length > 6 ? _args7[6] : undefined;
          isMirrorSync = _args7.length > 7 ? _args7[7] : undefined;
          allUsersGroupId = _args7.length > 8 ? _args7[8] : undefined;
          syncTs = _args7.length > 9 ? _args7[9] : undefined;
          pageIndex = _args7.length > 10 && _args7[10] !== undefined ? _args7[10] : 0;
          _context7.prev = 6;
          service = credential.service;
          if (!grp.groupId) {
            service.users.list({
              customer: 'my_customer',
              orderBy: 'email',
              maxResults: 500,
              pageToken: NextPageToken || ""
            }, /*#__PURE__*/function () {
              var _ref5 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(err, res) {
                var _res$data$users, _res$data, _res$data$nextPageTok, _res$data2, users, nextLink, _queue$create;
                return _regenerator["default"].wrap(function _callee3$(_context3) {
                  while (1) switch (_context3.prev = _context3.next) {
                    case 0:
                      if (!err) {
                        _context3.next = 8;
                        break;
                      }
                      _context3.next = 3;
                      return (0, _updateSyncingStatusGroups.updateSyncingStatusOfGroups)(grp._id, companyId);
                    case 3:
                      _context3.next = 5;
                      return db.Domain.updateOne({
                        _id: domainId
                      }, {
                        isSyncingUser: false,
                        syncEndAt: new Date(),
                        isSyncingUserError: true,
                        isSyncingUserErrorFile: JSON.stringify(err)
                      });
                    case 5:
                      return _context3.abrupt("return", console.error('The API returned an error:', err.message));
                    case 8:
                      users = (_res$data$users = res === null || res === void 0 ? void 0 : (_res$data = res.data) === null || _res$data === void 0 ? void 0 : _res$data.users) !== null && _res$data$users !== void 0 ? _res$data$users : [];
                      console.log('----->', users);
                      nextLink = (_res$data$nextPageTok = res === null || res === void 0 ? void 0 : (_res$data2 = res.data) === null || _res$data2 === void 0 ? void 0 : _res$data2.nextPageToken) !== null && _res$data$nextPageTok !== void 0 ? _res$data$nextPageTok : null;
                      if (users.length) {
                        _kue.queue.create('gsuite-user-save', (_queue$create = {
                          users: users,
                          domainId: domainId,
                          domainName: domainName,
                          companyId: companyId,
                          subDomainGroups: subDomainGroups,
                          isLast: nextLink ? false : true,
                          group: grp
                        }, (0, _defineProperty2["default"])(_queue$create, "domainName", domainName), (0, _defineProperty2["default"])(_queue$create, "isMirrorSync", isMirrorSync), (0, _defineProperty2["default"])(_queue$create, "allUsersGroupId", allUsersGroupId), (0, _defineProperty2["default"])(_queue$create, "syncTs", syncTs), (0, _defineProperty2["default"])(_queue$create, "pageIndex", pageIndex), (0, _defineProperty2["default"])(_queue$create, "isFirstPage", pageIndex === 0), _queue$create)).removeOnComplete(true).priority('high').save();
                      }
                      if (!nextLink) {
                        _context3.next = 14;
                        break;
                      }
                      return _context3.abrupt("return", getUsers(domainId, domainName, subDomainGroups, companyId, credential, nextLink, grp, isMirrorSync, allUsersGroupId, syncTs, pageIndex + 1));
                    case 14:
                    case "end":
                      return _context3.stop();
                  }
                }, _callee3);
              }));
              return function (_x8, _x9) {
                return _ref5.apply(this, arguments);
              };
            }());
          } else {
            service.groups.get({
              groupKey: grp.groupId
            }, /*#__PURE__*/function () {
              var _ref6 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee6(err, res) {
                var group, loop, _loop;
                return _regenerator["default"].wrap(function _callee6$(_context6) {
                  while (1) switch (_context6.prev = _context6.next) {
                    case 0:
                      _loop = function _loop3() {
                        _loop = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee5(nextPageToken) {
                          return _regenerator["default"].wrap(function _callee5$(_context5) {
                            while (1) switch (_context5.prev = _context5.next) {
                              case 0:
                                // Fetching Group Members
                                service.members.list({
                                  groupKey: group.email,
                                  customer: 'my_customer',
                                  orderBy: 'email',
                                  maxResults: 500,
                                  pageToken: nextPageToken || ''
                                  // fields: 'members(id,email)'
                                }, /*#__PURE__*/function () {
                                  var _ref7 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(membersErr, membersRes) {
                                    var _membersRes$data$memb, _membersRes$data, _res$data$nextPageTok2, _res$data3, members, membersObj, users, _nextPageToken;
                                    return _regenerator["default"].wrap(function _callee4$(_context4) {
                                      while (1) switch (_context4.prev = _context4.next) {
                                        case 0:
                                          _context4.prev = 0;
                                          if (membersErr) {
                                            console.log("Error Fetching Group Members", membersErr);
                                          }
                                          members = (_membersRes$data$memb = membersRes === null || membersRes === void 0 ? void 0 : (_membersRes$data = membersRes.data) === null || _membersRes$data === void 0 ? void 0 : _membersRes$data.members) !== null && _membersRes$data$memb !== void 0 ? _membersRes$data$memb : [];
                                          membersObj = {};
                                          members.forEach(function (m) {
                                            membersObj[m.email] = m;
                                          });
                                          console.log("members------>", members);
                                          _context4.next = 8;
                                          return getGsuiteUsers({
                                            emails: Object.keys(membersObj),
                                            service: service
                                          });
                                        case 8:
                                          users = _context4.sent;
                                          console.log("users------>", users);
                                          _kue.queue.create('gsuite-user-save', {
                                            users: users,
                                            domainId: domainId,
                                            companyId: companyId,
                                            subDomainGroups: subDomainGroups,
                                            isLast: _nextPageToken ? false : true,
                                            group: grp,
                                            domainName: domainName,
                                            isMirrorSync: isMirrorSync,
                                            allUsersGroupId: allUsersGroupId,
                                            syncTs: syncTs,
                                            pageIndex: pageIndex,
                                            isFirstPage: pageIndex === 0
                                          }).removeOnComplete(true).priority('high').save();
                                          _nextPageToken = (_res$data$nextPageTok2 = res === null || res === void 0 ? void 0 : (_res$data3 = res.data) === null || _res$data3 === void 0 ? void 0 : _res$data3.nextPageToken) !== null && _res$data$nextPageTok2 !== void 0 ? _res$data$nextPageTok2 : null;
                                          if (_nextPageToken) {
                                            _context4.next = 15;
                                            break;
                                          }
                                          console.log('all-users-tpir fetched');
                                          return _context4.abrupt("return", true);
                                        case 15:
                                          loop(_nextPageToken);
                                          _context4.next = 25;
                                          break;
                                        case 18:
                                          _context4.prev = 18;
                                          _context4.t0 = _context4["catch"](0);
                                          _context4.next = 22;
                                          return (0, _updateSyncingStatusGroups.updateSyncingStatusOfGroups)(grp._id, companyId);
                                        case 22:
                                          _context4.next = 24;
                                          return db.Domain.updateOne({
                                            _id: domainId
                                          }, {
                                            isSyncingUser: false,
                                            syncEndAt: new Date(),
                                            isSyncingUserError: true,
                                            isSyncingUserErrorFile: JSON.stringify(_context4.t0)
                                          });
                                        case 24:
                                          console.log(_context4.t0);
                                        case 25:
                                        case "end":
                                          return _context4.stop();
                                      }
                                    }, _callee4, null, [[0, 18]]);
                                  }));
                                  return function (_x13, _x14) {
                                    return _ref7.apply(this, arguments);
                                  };
                                }());
                              case 1:
                              case "end":
                                return _context5.stop();
                            }
                          }, _callee5);
                        }));
                        return _loop.apply(this, arguments);
                      };
                      loop = function _loop2(_x12) {
                        return _loop.apply(this, arguments);
                      };
                      if (!err) {
                        _context6.next = 8;
                        break;
                      }
                      _context6.next = 5;
                      return (0, _updateSyncingStatusGroups.updateSyncingStatusOfGroups)(grp._id, companyId);
                    case 5:
                      _context6.next = 7;
                      return db.Domain.updateOne({
                        _id: domainId
                      }, {
                        isSyncingUser: false,
                        syncEndAt: new Date(),
                        isSyncingUserError: true,
                        isSyncingUserErrorFile: JSON.stringify(err)
                      });
                    case 7:
                      return _context6.abrupt("return", reject(new RequestError(err)));
                    case 8:
                      group = res === null || res === void 0 ? void 0 : res.data;
                      if (!group) {
                        console.log("Group with ID ".concat(grp.groupId, " not found."));
                      }
                      loop();
                    case 11:
                    case "end":
                      return _context6.stop();
                  }
                }, _callee6);
              }));
              return function (_x10, _x11) {
                return _ref6.apply(this, arguments);
              };
            }());
          }
          _context7.next = 17;
          break;
        case 11:
          _context7.prev = 11;
          _context7.t0 = _context7["catch"](6);
          console.log(_context7.t0);
          _context7.next = 16;
          return (0, _updateSyncingStatusGroups.updateSyncingStatusOfGroups)(grp._id, companyId);
        case 16:
          return _context7.abrupt("return", db.Domain.updateOne({
            _id: domainId
          }, {
            isSyncingUser: false,
            syncEndAt: new Date(),
            isSyncingUserError: true,
            isSyncingUserErrorFile: JSON.stringify(_context7.t0)
          }));
        case 17:
        case "end":
          return _context7.stop();
      }
    }, _callee7, null, [[6, 11]]);
  }));
  return function getUsers(_x3, _x4, _x5, _x6, _x7) {
    return _ref4.apply(this, arguments);
  };
}();
var _default = {
  processUser: function processUser(domainId, domainName, subDomainGroups, companyId, credential) {
    var nextPageToken = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : null;
    var group = arguments.length > 6 ? arguments[6] : undefined;
    return getUsers(domainId, domainName, subDomainGroups, companyId, credential, nextPageToken, group);
  }
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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