"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _axios = _interopRequireDefault(require("axios"));
var _config = _interopRequireDefault(require("../config"));
var getIpLocation = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(ipAddress) {
    var axiosConfig;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          axiosConfig = {};
          if (_config["default"].proxy.enableForIpLocation) {
            axiosConfig.httpsAgent = _config["default"].proxy.proxyAgent;
            axiosConfig.httpAgent = _config["default"].proxy.proxyAgent;
          }
          return _context.abrupt("return", new Promise(function (resolve, reject) {
            _axios["default"].get("https://www.iplocate.io/api/lookup/".concat(ipAddress, "?apikey=").concat(_config["default"].iplocate.apikey), axiosConfig).then(function (res) {
              if (res.data) {
                var country = res.data.country;
                var continent = res.data.continent;
                resolve({
                  country: country,
                  continent: continent
                });
              } else {
                resolve({
                  country: null,
                  continent: null
                });
              }
            })["catch"](function (err) {
              console.log(JSON.stringify(err));
              resolve({
                country: null,
                continent: null
              });
            });
          }));
        case 6:
          _context.prev = 6;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          resolve({
            country: null,
            continent: null
          });
        case 10:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 6]]);
  }));
  return function getIpLocation(_x) {
    return _ref.apply(this, arguments);
  };
}();
var _default = {
  processIp: function processIp(ipAddress) {
    return getIpLocation(ipAddress);
  }
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJnZXRJcExvY2F0aW9uIiwiaXBBZGRyZXNzIiwiYXhpb3NDb25maWciLCJjb25maWciLCJwcm94eSIsImVuYWJsZUZvcklwTG9jYXRpb24iLCJodHRwc0FnZW50IiwicHJveHlBZ2VudCIsImh0dHBBZ2VudCIsIlByb21pc2UiLCJyZXNvbHZlIiwicmVqZWN0IiwiYXhpb3MiLCJnZXQiLCJpcGxvY2F0ZSIsImFwaWtleSIsInRoZW4iLCJyZXMiLCJkYXRhIiwiY291bnRyeSIsImNvbnRpbmVudCIsImVyciIsImNvbnNvbGUiLCJsb2ciLCJKU09OIiwic3RyaW5naWZ5IiwicHJvY2Vzc0lwIl0sInNvdXJjZXMiOlsiLi4vLi4vc3JjL3NlcnZpY2UvZ2V0LWlwLmpzIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBheGlvcyBmcm9tICdheGlvcyc7XG5pbXBvcnQgY29uZmlnIGZyb20gJy4uL2NvbmZpZyc7XG5cbmNvbnN0IGdldElwTG9jYXRpb24gPSBhc3luYyBmdW5jdGlvbiAoaXBBZGRyZXNzKSB7XG4gICAgdHJ5IHtcbiAgICAgICAgY29uc3QgYXhpb3NDb25maWcgPSB7fTtcblxuICAgICAgICBpZiAoY29uZmlnLnByb3h5LmVuYWJsZUZvcklwTG9jYXRpb24pIHtcbiAgICAgICAgICAgIGF4aW9zQ29uZmlnLmh0dHBzQWdlbnQgPSBjb25maWcucHJveHkucHJveHlBZ2VudDtcbiAgICAgICAgICAgIGF4aW9zQ29uZmlnLmh0dHBBZ2VudCA9IGNvbmZpZy5wcm94eS5wcm94eUFnZW50O1xuICAgICAgICB9XG5cbiAgICAgICAgcmV0dXJuIG5ldyBQcm9taXNlKChyZXNvbHZlLCByZWplY3QpID0+IHtcbiAgICAgICAgICAgIGF4aW9zLmdldChgaHR0cHM6Ly93d3cuaXBsb2NhdGUuaW8vYXBpL2xvb2t1cC8ke2lwQWRkcmVzc30/YXBpa2V5PSR7Y29uZmlnLmlwbG9jYXRlLmFwaWtleX1gLGF4aW9zQ29uZmlnKVxuICAgICAgICAgICAgLnRoZW4ocmVzID0+IHtcbiAgICAgICAgICAgICAgICBpZiAocmVzLmRhdGEpIHtcbiAgICAgICAgICAgICAgICAgICAgbGV0IGNvdW50cnkgPSByZXMuZGF0YS5jb3VudHJ5O1xuICAgICAgICAgICAgICAgICAgICBsZXQgY29udGluZW50ID0gcmVzLmRhdGEuY29udGluZW50O1xuICAgICAgICAgICAgICAgICAgICByZXNvbHZlKHsgY291bnRyeSwgY29udGluZW50IH0pO1xuICAgICAgICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIHJlc29sdmUoeyBjb3VudHJ5OiBudWxsLCBjb250aW5lbnQ6IG51bGwgfSlcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9KVxuICAgICAgICAgICAgLmNhdGNoKGVyciA9PiB7XG4gICAgICAgICAgICAgICAgY29uc29sZS5sb2coSlNPTi5zdHJpbmdpZnkoZXJyKSk7XG4gICAgICAgICAgICAgICAgcmVzb2x2ZSh7IGNvdW50cnk6IG51bGwsIGNvbnRpbmVudDogbnVsbCB9KVxuICAgICAgICAgICAgfSlcbiAgICAgICAgfSlcbiAgICB9IGNhdGNoIChlcnIpIHtcbiAgICAgICAgY29uc29sZS5sb2coZXJyKTtcbiAgICAgICAgcmVzb2x2ZSh7IGNvdW50cnk6IG51bGwsIGNvbnRpbmVudDogbnVsbCB9KVxuICAgIH1cbn1cblxuZXhwb3J0IGRlZmF1bHQge1xuICAgIHByb2Nlc3NJcDogKGlwQWRkcmVzcykgPT4ge1xuICAgICAgICByZXR1cm4gZ2V0SXBMb2NhdGlvbihpcEFkZHJlc3MpO1xuICAgIH1cbn0iXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUFBO0FBQ0E7QUFFQSxJQUFNQSxhQUFhO0VBQUEseUZBQUcsaUJBQWdCQyxTQUFTO0lBQUE7SUFBQTtNQUFBO1FBQUE7VUFBQTtVQUVqQ0MsV0FBVyxHQUFHLENBQUMsQ0FBQztVQUV0QixJQUFJQyxrQkFBTSxDQUFDQyxLQUFLLENBQUNDLG1CQUFtQixFQUFFO1lBQ2xDSCxXQUFXLENBQUNJLFVBQVUsR0FBR0gsa0JBQU0sQ0FBQ0MsS0FBSyxDQUFDRyxVQUFVO1lBQ2hETCxXQUFXLENBQUNNLFNBQVMsR0FBR0wsa0JBQU0sQ0FBQ0MsS0FBSyxDQUFDRyxVQUFVO1VBQ25EO1VBQUMsaUNBRU0sSUFBSUUsT0FBTyxDQUFDLFVBQUNDLE9BQU8sRUFBRUMsTUFBTSxFQUFLO1lBQ3BDQyxpQkFBSyxDQUFDQyxHQUFHLDhDQUF1Q1osU0FBUyxxQkFBV0Usa0JBQU0sQ0FBQ1csUUFBUSxDQUFDQyxNQUFNLEdBQUdiLFdBQVcsQ0FBQyxDQUN4R2MsSUFBSSxDQUFDLFVBQUFDLEdBQUcsRUFBSTtjQUNULElBQUlBLEdBQUcsQ0FBQ0MsSUFBSSxFQUFFO2dCQUNWLElBQUlDLE9BQU8sR0FBR0YsR0FBRyxDQUFDQyxJQUFJLENBQUNDLE9BQU87Z0JBQzlCLElBQUlDLFNBQVMsR0FBR0gsR0FBRyxDQUFDQyxJQUFJLENBQUNFLFNBQVM7Z0JBQ2xDVixPQUFPLENBQUM7a0JBQUVTLE9BQU8sRUFBUEEsT0FBTztrQkFBRUMsU0FBUyxFQUFUQTtnQkFBVSxDQUFDLENBQUM7Y0FDbkMsQ0FBQyxNQUFNO2dCQUNIVixPQUFPLENBQUM7a0JBQUVTLE9BQU8sRUFBRSxJQUFJO2tCQUFFQyxTQUFTLEVBQUU7Z0JBQUssQ0FBQyxDQUFDO2NBQy9DO1lBQ0osQ0FBQyxDQUFDLFNBQ0ksQ0FBQyxVQUFBQyxHQUFHLEVBQUk7Y0FDVkMsT0FBTyxDQUFDQyxHQUFHLENBQUNDLElBQUksQ0FBQ0MsU0FBUyxDQUFDSixHQUFHLENBQUMsQ0FBQztjQUNoQ1gsT0FBTyxDQUFDO2dCQUFFUyxPQUFPLEVBQUUsSUFBSTtnQkFBRUMsU0FBUyxFQUFFO2NBQUssQ0FBQyxDQUFDO1lBQy9DLENBQUMsQ0FBQztVQUNOLENBQUMsQ0FBQztRQUFBO1VBQUE7VUFBQTtVQUVGRSxPQUFPLENBQUNDLEdBQUcsYUFBSztVQUNoQmIsT0FBTyxDQUFDO1lBQUVTLE9BQU8sRUFBRSxJQUFJO1lBQUVDLFNBQVMsRUFBRTtVQUFLLENBQUMsQ0FBQztRQUFBO1FBQUE7VUFBQTtNQUFBO0lBQUE7RUFBQSxDQUVsRDtFQUFBLGdCQTdCS3BCLGFBQWE7SUFBQTtFQUFBO0FBQUEsR0E2QmxCO0FBQUEsZUFFYztFQUNYMEIsU0FBUyxFQUFFLG1CQUFDekIsU0FBUyxFQUFLO0lBQ3RCLE9BQU9ELGFBQWEsQ0FBQ0MsU0FBUyxDQUFDO0VBQ25DO0FBQ0osQ0FBQztBQUFBIn0=