"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _axios = _interopRequireDefault(require("axios"));
var _config = _interopRequireDefault(require("../config"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var axiosConfig = {
  httpsAgent: _config["default"].proxy.enableForMicrosoftGraph ? _config["default"].proxy.proxyAgent : undefined,
  httpAgent: _config["default"].proxy.enableForMicrosoftGraph ? _config["default"].proxy.proxyAgent : undefined
};
var getHeader = function getHeader(messageId, accessToken) {
  return new Promise(function (resolve, reject) {
    var getMessageUrl = "https://outlook.office365.com/api/v2.0/me/messages/".concat(messageId, "?$select=SingleValueExtendedProperties&$expand=SingleValueExtendedProperties($filter=PropertyId eq 'String 0x007D')");
    _axios["default"].get(getMessageUrl, _objectSpread({
      headers: {
        Authorization: "Bearer " + accessToken,
        Accept: "application/json; odata.metadata=none"
      }
    }, axiosConfig)).then(function (response) {
      if (response.data && response.data.SingleValueExtendedProperties && response.data.SingleValueExtendedProperties.length) {
        resolve(response.data.SingleValueExtendedProperties[0].Value);
      } else {
        reject(new RequestError('Header not accessible'));
      }
    })["catch"](function (err) {
      console.log("-------------------->", err.response.data);
      reject(err);
    });
  });
};
var getHeaderGraph = function getHeaderGraph(messageId, accessToken, email) {
  return new Promise(function (resolve, reject) {
    var getMessageUrl = "https://graph.microsoft.com/v1.0/users/".concat(email, "/messages/").concat(messageId, "?$select=internetMessageHeaders");
    _axios["default"].get(getMessageUrl, _objectSpread({
      headers: {
        Authorization: "Bearer ".concat(accessToken),
        Accept: "application/json"
      }
    }, axiosConfig)).then(function (response) {
      console.log(response.data.internetMessageHeaders);
      if (response.data && response.data.internetMessageHeaders) {
        // Find the specific header using its ID (0x007D corresponds to 'PR_TRANSPORT_MESSAGE_HEADERS')
        var header = response.data.internetMessageHeaders.find(function (h) {
          return h.name.toLowerCase() === "x-ms-exchange-organization-originalsize";
        });
        if (header) {
          resolve(header.value);
        } else {
          reject(new Error('Header not found'));
        }
      } else {
        reject(new Error('Header data not accessible'));
      }
    })["catch"](function (err) {
      var _err$response;
      console.log("-------------------->", ((_err$response = err.response) === null || _err$response === void 0 ? void 0 : _err$response.data) || err.message);
      reject(err);
    });
  });
};
var getBody = function getBody(messageId, accessToken) {
  return new Promise(function (resolve, reject) {
    var getMessageUrl = "https://outlook.office365.com/api/v2.0/me/messages/".concat(messageId);
    _axios["default"].get(getMessageUrl, _objectSpread({
      headers: {
        Authorization: "Bearer " + accessToken,
        Accept: "application/json; odata.metadata=none"
      }
    }, axiosConfig)).then(function (response) {
      if (response.data && response.data.Body && response.data.Body.Content) {
        resolve(response.data.Body.Content);
      } else {
        reject(new RequestError('Body not accessble'));
      }
    })["catch"](function (err) {
      console.log("------------------->", err.response.data);
      reject(err);
    });
  });
};
var getAttachments = function getAttachments(messageId, accessToken) {
  return new Promise(function (resolve, reject) {
    var getMessageUrl = "https://outlook.office365.com/api/v2.0/me/messages/".concat(messageId, "/attachments");
    _axios["default"].get(getMessageUrl, _objectSpread({
      headers: {
        Authorization: "Bearer " + accessToken,
        Accept: "application/json; odata.metadata=none"
      }
    }, axiosConfig)).then(function (response) {
      resolve(response.data.value);
    })["catch"](function (err) {
      console.log("------------------->", err.response.data);
      reject(err);
    });
  });
};
var getEml = function getEml(messageId, accessToken) {
  return new Promise(function (resolve, reject) {
    var getMessageUrl = "https://outlook.office365.com/api/v2.0/me/messages/".concat(messageId, "/$value");
    _axios["default"].get(getMessageUrl, _objectSpread({
      headers: {
        Authorization: "Bearer " + accessToken,
        Accept: "application/json; odata.metadata=none"
      }
    }, axiosConfig)).then(function (response) {
      resolve(response.data);
    })["catch"](function (err) {
      reject(err);
    });
  });
};
var getBodyGraph = function getBodyGraph(messageId, accessToken, email) {
  return new Promise(function (resolve, reject) {
    var getMessageUrl = "https://graph.microsoft.com/v1.0/users/".concat(email, "/messages/").concat(messageId, "?$select=body");
    _axios["default"].get(getMessageUrl, _objectSpread({
      headers: {
        Authorization: "Bearer ".concat(accessToken),
        Accept: "application/json"
      }
    }, axiosConfig)).then(function (response) {
      if (response.data && response.data.body && response.data.body.content) {
        resolve(response.data.body.content);
      } else {
        reject(new Error('Body not accessible'));
      }
    })["catch"](function (err) {
      var _err$response2;
      console.log("------------------->", ((_err$response2 = err.response) === null || _err$response2 === void 0 ? void 0 : _err$response2.data) || err.message);
      reject(err);
    });
  });
};
var getAttachmentsGraph = function getAttachmentsGraph(messageId, accessToken, email) {
  return new Promise(function (resolve, reject) {
    var getMessageUrl = "https://graph.microsoft.com/v1.0/users/".concat(email, "/messages/").concat(messageId, "/attachments");
    _axios["default"].get(getMessageUrl, _objectSpread({
      headers: {
        Authorization: "Bearer ".concat(accessToken),
        Accept: "application/json"
      }
    }, axiosConfig)).then(function (response) {
      resolve(response.data.value);
    })["catch"](function (err) {
      var _err$response3;
      console.log("------------------->", ((_err$response3 = err.response) === null || _err$response3 === void 0 ? void 0 : _err$response3.data) || err.message);
      reject(err);
    });
  });
};
var getEmlGraph = function getEmlGraph(messageId, accessToken, email) {
  return new Promise(function (resolve, reject) {
    var getMessageUrl = "https://graph.microsoft.com/v1.0/users/".concat(email, "/messages/").concat(messageId, "/$value");
    _axios["default"].get(getMessageUrl, _objectSpread({
      headers: {
        Authorization: "Bearer ".concat(accessToken),
        Accept: "message/rfc822"
      }
    }, axiosConfig)).then(function (response) {
      resolve(response.data);
    })["catch"](function (err) {
      var _err$response4;
      console.log("------------------->", ((_err$response4 = err.response) === null || _err$response4 === void 0 ? void 0 : _err$response4.data) || err.message);
      reject(err);
    });
  });
};
var getFolderId = function getFolderId(messageId, accessToken) {
  return new Promise(function (resolve, reject) {
    var getMessageUrl = "https://outlook.office365.com/api/v2.0/me/messages/".concat(messageId, "?$select=ParentFolderId");
    _axios["default"].get(getMessageUrl, _objectSpread({
      headers: {
        Authorization: "Bearer " + accessToken,
        Accept: "application/json; odata.metadata=none"
      }
    }, axiosConfig)).then(function (response) {
      resolve(response.data.ParentFolderId);
    })["catch"](function (err) {
      console.log("------------------->", err.response.data);
      reject(err);
    });
  });
};
var getFolderIdGraph = function getFolderIdGraph(messageId, accessToken, email) {
  return new Promise(function (resolve, reject) {
    var getMessageUrl = "https://graph.microsoft.com/v1.0/users/".concat(email, "/messages/").concat(messageId, "?$select=parentFolderId");
    _axios["default"].get(getMessageUrl, _objectSpread({
      headers: {
        Authorization: "Bearer ".concat(accessToken),
        Accept: "application/json"
      }
    }, axiosConfig)).then(function (response) {
      resolve(response.data.parentFolderId);
    })["catch"](function (err) {
      var _err$response5;
      console.log("------------------->", (_err$response5 = err.response) === null || _err$response5 === void 0 ? void 0 : _err$response5.data);
      reject(err);
    });
  });
};
var moveToJunk = function moveToJunk(messageId, accessToken, email) {
  return new Promise(function (resolve, reject) {
    var moveMessageUrl = "https://graph.microsoft.com/v1.0/users/".concat(email, "/messages/").concat(messageId, "/move");
    _axios["default"].post(moveMessageUrl, {
      destinationId: "deleteditems"
    }, _objectSpread({
      headers: {
        Authorization: "Bearer ".concat(accessToken),
        Accept: "application/json",
        "Content-Type": "application/json"
      }
    }, axiosConfig)).then(function (response) {
      console.log("-------------------Email Moved To Trash Successfully!--------------------");
      resolve(response.data);
    })["catch"](function (err) {
      var _err$response6;
      console.log("------------------->", (_err$response6 = err.response) === null || _err$response6 === void 0 ? void 0 : _err$response6.data);
      reject(err);
    });
  });
};
var _default = {
  processMail: function () {
    var _processMail = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(messageId, accessToken) {
      var body, headers;
      return _regenerator["default"].wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return getBody(messageId, accessToken);
          case 2:
            body = _context.sent;
            _context.next = 5;
            return getHeader(messageId, accessToken);
          case 5:
            headers = _context.sent;
            return _context.abrupt("return", "".concat(headers, "\r\n").concat(body));
          case 7:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    function processMail(_x, _x2) {
      return _processMail.apply(this, arguments);
    }
    return processMail;
  }(),
  processHeader: function () {
    var _processHeader = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(messageId, accessToken) {
      return _regenerator["default"].wrap(function _callee2$(_context2) {
        while (1) switch (_context2.prev = _context2.next) {
          case 0:
            return _context2.abrupt("return", getHeader(messageId, accessToken));
          case 1:
          case "end":
            return _context2.stop();
        }
      }, _callee2);
    }));
    function processHeader(_x3, _x4) {
      return _processHeader.apply(this, arguments);
    }
    return processHeader;
  }(),
  processHeaderGraph: function () {
    var _processHeaderGraph = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(messageId, accessToken, email) {
      return _regenerator["default"].wrap(function _callee3$(_context3) {
        while (1) switch (_context3.prev = _context3.next) {
          case 0:
            return _context3.abrupt("return", getHeaderGraph(messageId, accessToken, email));
          case 1:
          case "end":
            return _context3.stop();
        }
      }, _callee3);
    }));
    function processHeaderGraph(_x5, _x6, _x7) {
      return _processHeaderGraph.apply(this, arguments);
    }
    return processHeaderGraph;
  }(),
  processBody: function () {
    var _processBody = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(messageId, accessToken) {
      return _regenerator["default"].wrap(function _callee4$(_context4) {
        while (1) switch (_context4.prev = _context4.next) {
          case 0:
            return _context4.abrupt("return", getBody(messageId, accessToken));
          case 1:
          case "end":
            return _context4.stop();
        }
      }, _callee4);
    }));
    function processBody(_x8, _x9) {
      return _processBody.apply(this, arguments);
    }
    return processBody;
  }(),
  processBodyGraph: function () {
    var _processBodyGraph = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee5(messageId, accessToken, email) {
      return _regenerator["default"].wrap(function _callee5$(_context5) {
        while (1) switch (_context5.prev = _context5.next) {
          case 0:
            return _context5.abrupt("return", getBodyGraph(messageId, accessToken, email));
          case 1:
          case "end":
            return _context5.stop();
        }
      }, _callee5);
    }));
    function processBodyGraph(_x10, _x11, _x12) {
      return _processBodyGraph.apply(this, arguments);
    }
    return processBodyGraph;
  }(),
  processAttachments: function () {
    var _processAttachments = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee6(messageId, accessToken) {
      return _regenerator["default"].wrap(function _callee6$(_context6) {
        while (1) switch (_context6.prev = _context6.next) {
          case 0:
            return _context6.abrupt("return", getAttachments(messageId, accessToken));
          case 1:
          case "end":
            return _context6.stop();
        }
      }, _callee6);
    }));
    function processAttachments(_x13, _x14) {
      return _processAttachments.apply(this, arguments);
    }
    return processAttachments;
  }(),
  processAttachmentsGraph: function () {
    var _processAttachmentsGraph = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee7(messageId, accessToken, email) {
      return _regenerator["default"].wrap(function _callee7$(_context7) {
        while (1) switch (_context7.prev = _context7.next) {
          case 0:
            return _context7.abrupt("return", getAttachmentsGraph(messageId, accessToken, email));
          case 1:
          case "end":
            return _context7.stop();
        }
      }, _callee7);
    }));
    function processAttachmentsGraph(_x15, _x16, _x17) {
      return _processAttachmentsGraph.apply(this, arguments);
    }
    return processAttachmentsGraph;
  }(),
  processEml: function () {
    var _processEml = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee8(messageId, accessToken) {
      return _regenerator["default"].wrap(function _callee8$(_context8) {
        while (1) switch (_context8.prev = _context8.next) {
          case 0:
            return _context8.abrupt("return", getEml(messageId, accessToken));
          case 1:
          case "end":
            return _context8.stop();
        }
      }, _callee8);
    }));
    function processEml(_x18, _x19) {
      return _processEml.apply(this, arguments);
    }
    return processEml;
  }(),
  processEmlGraph: function () {
    var _processEmlGraph = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee9(messageId, accessToken, email) {
      return _regenerator["default"].wrap(function _callee9$(_context9) {
        while (1) switch (_context9.prev = _context9.next) {
          case 0:
            return _context9.abrupt("return", getEmlGraph(messageId, accessToken, email));
          case 1:
          case "end":
            return _context9.stop();
        }
      }, _callee9);
    }));
    function processEmlGraph(_x20, _x21, _x22) {
      return _processEmlGraph.apply(this, arguments);
    }
    return processEmlGraph;
  }(),
  processFolderId: function () {
    var _processFolderId = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee10(messageId, accessToken) {
      return _regenerator["default"].wrap(function _callee10$(_context10) {
        while (1) switch (_context10.prev = _context10.next) {
          case 0:
            return _context10.abrupt("return", getFolderId(messageId, accessToken));
          case 1:
          case "end":
            return _context10.stop();
        }
      }, _callee10);
    }));
    function processFolderId(_x23, _x24) {
      return _processFolderId.apply(this, arguments);
    }
    return processFolderId;
  }(),
  processFolderIdGraph: function () {
    var _processFolderIdGraph = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee11(messageId, accessToken, email) {
      return _regenerator["default"].wrap(function _callee11$(_context11) {
        while (1) switch (_context11.prev = _context11.next) {
          case 0:
            return _context11.abrupt("return", getFolderIdGraph(messageId, accessToken, email));
          case 1:
          case "end":
            return _context11.stop();
        }
      }, _callee11);
    }));
    function processFolderIdGraph(_x25, _x26, _x27) {
      return _processFolderIdGraph.apply(this, arguments);
    }
    return processFolderIdGraph;
  }(),
  moveEmailToJunk: function () {
    var _moveEmailToJunk = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee12(messageId, accessToken, email) {
      return _regenerator["default"].wrap(function _callee12$(_context12) {
        while (1) switch (_context12.prev = _context12.next) {
          case 0:
            return _context12.abrupt("return", moveToJunk(messageId, accessToken, email));
          case 1:
          case "end":
            return _context12.stop();
        }
      }, _callee12);
    }));
    function moveEmailToJunk(_x28, _x29, _x30) {
      return _moveEmailToJunk.apply(this, arguments);
    }
    return moveEmailToJunk;
  }()
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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