"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _axios = _interopRequireDefault(require("axios"));
var _config = _interopRequireDefault(require("../config"));
var _default = {
  getHackRecord: function getHackRecord(email) {
    return new Promise(function (resolve, reject) {
      (0, _axios["default"])({
        method: 'GET',
        url: "".concat(_config["default"].hackRecord.url, "/api/v3/breachedaccount/").concat(email, "?truncateResponse=false"),
        headers: {
          'User-Agent': 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36',
          'hibp-api-key': _config["default"].hackRecord.apiKey
        }
      }).then(function (result) {
        resolve(result);
      })["catch"](function (err) {
        reject(err && err.message ? new RequestError(err.message, 404) : new RequestError('Error fetching hack record', 404));
      });
    });
  }
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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