"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _config = _interopRequireDefault(require("../config"));
var _path = _interopRequireDefault(require("path"));
var vision = require('@google-cloud/vision');
var _require = require('google-gax'),
  GoogleAuth = _require.GoogleAuth,
  grpc = _require.grpc;
var apiKey = _config["default"].imageToText.apiKey;
function getApiKeyCredentials() {
  var sslCreds = grpc.credentials.createSsl();
  var googleAuth = new GoogleAuth();
  var authClient = googleAuth.fromAPIKey(apiKey);
  var credentials = grpc.credentials.combineChannelCredentials(sslCreds, grpc.credentials.createFromGoogleCredential(authClient));
  return credentials;
}
var scanResult = function scanResult(data) {
  return new Promise( /*#__PURE__*/function () {
    var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(resolve, reject) {
      var _result$fullTextAnnot, sslCreds, client, _yield$client$textDet, _yield$client$textDet2, result;
      return _regenerator["default"].wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _context.prev = 0;
            sslCreds = getApiKeyCredentials();
            client = new vision.ImageAnnotatorClient({
              sslCreds: sslCreds
            });
            _context.next = 5;
            return client.textDetection(_path["default"].join(appRoot, "Content", "whatsappImages", data));
          case 5:
            _yield$client$textDet = _context.sent;
            _yield$client$textDet2 = (0, _slicedToArray2["default"])(_yield$client$textDet, 1);
            result = _yield$client$textDet2[0];
            resolve(result === null || result === void 0 ? void 0 : (_result$fullTextAnnot = result.fullTextAnnotation) === null || _result$fullTextAnnot === void 0 ? void 0 : _result$fullTextAnnot.text);
            _context.next = 15;
            break;
          case 11:
            _context.prev = 11;
            _context.t0 = _context["catch"](0);
            console.log("Error From Vision API while Converting Image-To-Text", _context.t0);
            resolve(false);
          case 15:
          case "end":
            return _context.stop();
        }
      }, _callee, null, [[0, 11]]);
    }));
    return function (_x, _x2) {
      return _ref.apply(this, arguments);
    };
  }());
};
var _default = {
  imageToText: function () {
    var _imageToText = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(data) {
      return _regenerator["default"].wrap(function _callee2$(_context2) {
        while (1) switch (_context2.prev = _context2.next) {
          case 0:
            return _context2.abrupt("return", scanResult(data));
          case 1:
          case "end":
            return _context2.stop();
        }
      }, _callee2);
    }));
    function imageToText(_x3) {
      return _imageToText.apply(this, arguments);
    }
    return imageToText;
  }()
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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