"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var messages = {
  acknowledgmentMessage: {
    english: function english(ticketId) {
      return "*Ticket ID - ".concat(ticketId, "*. \n\nThank you for reporting to us. We will shortly provide you with the results.\n\n`Thank you for the commitment to online safety.`");
    },
    indonesian: function indonesian(ticketId) {
      return "*Tiket ID - ".concat(ticketId, "*. \n\nTerima kasih telah melaporkan kepada kami. Kami akan segera memberikan hasilnya.\n\n`Terima kasih atas komitmen Anda terhadap keamanan online.`");
    },
    arabic: function arabic(ticketId) {
      return "*\u0645\u0639\u0631\u0641 \u0627\u0644\u062A\u0630\u0643\u0631\u0629* - ".concat(ticketId, " \n\n\u0634\u0643\u0631\u064B\u0627 \u0644\u0643 \u0639\u0644\u0649 \u0627\u0644\u0625\u0628\u0644\u0627\u063A. \u0633\u0646\u0642\u062F\u0645 \u0644\u0643 \u0627\u0644\u0646\u062A\u0627\u0626\u062C \u0642\u0631\u064A\u0628\u064B\u0627.\n\n`\u0634\u0643\u0631\u064B\u0627 \u0644\u0643 \u0639\u0644\u0649 \u0627\u0644\u062A\u0632\u0627\u0645\u0643 \u0628\u0627\u0644\u0633\u0644\u0627\u0645\u0629 \u0639\u0628\u0631 \u0627\u0644\u0625\u0646\u062A\u0631\u0646\u062A.`");
    },
    french: function french(ticketId) {
      return "*Ticket ID - ".concat(ticketId, "*. \n\nMerci de nous avoir signal\xE9 ce probl\xE8me. Nous vous fournirons bient\xF4t les r\xE9sultats.\n\n`Merci pour votre engagement envers la s\xE9curit\xE9 en ligne.`");
    },
    spanish: function spanish(ticketId) {
      return "*Ticket ID - ".concat(ticketId, "*. \n\nGracias por informarnos. En breve le proporcionaremos los resultados.\n\n`Gracias por su compromiso con la seguridad en l\xEDnea.`");
    },
    german: function german(ticketId) {
      return "*Ticket ID - ".concat(ticketId, "*. \n\nDanke, dass Sie uns informiert haben. Wir werden Ihnen in K\xFCrze die Ergebnisse mitteilen.\n\n`Vielen Dank f\xFCr Ihr Engagement f\xFCr die Online-Sicherheit.`");
    },
    russian: function russian(ticketId) {
      return "*Ticket ID - ".concat(ticketId, "*. \n\n\u0421\u043F\u0430\u0441\u0438\u0431\u043E \u0437\u0430 \u0432\u0430\u0448\u0435 \u0441\u043E\u043E\u0431\u0449\u0435\u043D\u0438\u0435. \u0412 \u0431\u043B\u0438\u0436\u0430\u0439\u0448\u0435\u0435 \u0432\u0440\u0435\u043C\u044F \u043C\u044B \u043F\u0440\u0435\u0434\u043E\u0441\u0442\u0430\u0432\u0438\u043C \u0432\u0430\u043C \u0440\u0435\u0437\u0443\u043B\u044C\u0442\u0430\u0442\u044B.\n\n`\u0421\u043F\u0430\u0441\u0438\u0431\u043E \u0437\u0430 \u043F\u0440\u0438\u0432\u0435\u0440\u0436\u0435\u043D\u043D\u043E\u0441\u0442\u044C \u043E\u043D\u043B\u0430\u0439\u043D-\u0431\u0435\u0437\u043E\u043F\u0430\u0441\u043D\u043E\u0441\u0442\u0438.`");
    },
    chinese_simplified: function chinese_simplified(ticketId) {
      return "*Ticket ID - ".concat(ticketId, "*. \n\n\u611F\u8C22\u60A8\u7684\u4E3E\u62A5\u3002\u6211\u4EEC\u5C06\u5F88\u5FEB\u63D0\u4F9B\u7ED3\u679C\u3002\n\n`\u611F\u8C22\u60A8\u5BF9\u7F51\u7EDC\u5B89\u5168\u7684\u627F\u8BFA\u3002`");
    },
    chinese_traditional: function chinese_traditional(ticketId) {
      return "*Ticket ID - ".concat(ticketId, "*. \n\n\u611F\u8B1D\u60A8\u7684\u8209\u5831\u3002\u6211\u5011\u5C07\u5F88\u5FEB\u63D0\u4F9B\u7D50\u679C\u3002\n\n`\u611F\u8B1D\u60A8\u5C0D\u7DB2\u7D61\u5B89\u5168\u7684\u627F\u8AFE\u3002`");
    },
    japanese: function japanese(ticketId) {
      return "*Ticket ID - ".concat(ticketId, "*. \n\n\u3054\u5831\u544A\u3044\u305F\u3060\u304D\u3042\u308A\u304C\u3068\u3046\u3054\u3056\u3044\u307E\u3059\u3002\u7D50\u679C\u306F\u9593\u3082\u306A\u304F\u304A\u77E5\u3089\u305B\u3057\u307E\u3059\u3002\n\n`\u30AA\u30F3\u30E9\u30A4\u30F3\u5B89\u5168\u3078\u306E\u3054\u5354\u529B\u306B\u611F\u8B1D\u3057\u307E\u3059\u3002`");
    },
    korean: function korean(ticketId) {
      return "*Ticket ID - ".concat(ticketId, "*. \n\n\uC2E0\uACE0\uD574 \uC8FC\uC154\uC11C \uAC10\uC0AC\uD569\uB2C8\uB2E4. \uACE7 \uACB0\uACFC\uB97C \uC81C\uACF5\uD558\uACA0\uC2B5\uB2C8\uB2E4.\n\n`\uC628\uB77C\uC778 \uC548\uC804\uC744 \uC704\uD55C \uB178\uB825\uC5D0 \uAC10\uC0AC\uB4DC\uB9BD\uB2C8\uB2E4.`");
    }
  },
  investigationMessage: {
    english: function english(ticketId, overallResult, summary) {
      return "*Ticket Id* - ".concat(ticketId, " \n\nPlease find the investigation report below.\n\n*Investigated Content* - \nSafety Parameter - ").concat(overallResult, "\n\n").concat(summary, "\n\n`Thank you for the commitment to online safety.`");
    },
    indonesian: function indonesian(ticketId, overallResult, summary) {
      return "*Tiket Id* - ".concat(ticketId, " \n\nSilakan temukan laporan investigasi di bawah ini.\n\n*Konten yang Diselidiki* - \nParameter Keamanan - ").concat(overallResult, "\n\n").concat(summary, "\n\n`Terima kasih atas komitmen Anda terhadap keamanan online.`");
    },
    arabic: function arabic(ticketId, overallResult, summary) {
      return "*\u0645\u0639\u0631\u0641 \u0627\u0644\u062A\u0630\u0643\u0631\u0629* - ".concat(ticketId, " \n\n\u064A\u0631\u062C\u0649 \u0627\u0644\u0639\u062B\u0648\u0631 \u0639\u0644\u0649 \u062A\u0642\u0631\u064A\u0631 \u0627\u0644\u062A\u062D\u0642\u064A\u0642 \u0623\u062F\u0646\u0627\u0647.\n\n*\u0627\u0644\u0645\u062D\u062A\u0648\u0649 \u0627\u0644\u0630\u064A \u062A\u0645 \u0627\u0644\u062A\u062D\u0642\u064A\u0642 \u0641\u064A\u0647* - \n\u0645\u0639\u0627\u0645\u0644 \u0627\u0644\u0623\u0645\u0627\u0646 - ").concat(overallResult, "\n\n").concat(summary, "\n\n`\u0634\u0643\u0631\u064B\u0627 \u0644\u0643 \u0639\u0644\u0649 \u0627\u0644\u062A\u0632\u0627\u0645\u0643 \u0628\u0627\u0644\u0633\u0644\u0627\u0645\u0629 \u0639\u0628\u0631 \u0627\u0644\u0625\u0646\u062A\u0631\u0646\u062A.`");
    },
    french: function french(ticketId, overallResult, summary) {
      return "*Ticket Id* - ".concat(ticketId, " \n\nVeuillez trouver le rapport d'enqu\xEAte ci-dessous.\n\n*Contenu Enqu\xEAt\xE9* - \nParam\xE8tre de s\xE9curit\xE9 - ").concat(overallResult, "\n\n").concat(summary, "\n\n`Merci pour votre engagement envers la s\xE9curit\xE9 en ligne.`");
    },
    spanish: function spanish(ticketId, overallResult, summary) {
      return "*Ticket Id* - ".concat(ticketId, " \n\nPor favor, encuentre el informe de investigaci\xF3n a continuaci\xF3n.\n\n*Contenido Investigado* - \nPar\xE1metro de seguridad - ").concat(overallResult, "\n\n").concat(summary, "\n\n`Gracias por su compromiso con la seguridad en l\xEDnea.`");
    },
    german: function german(ticketId, overallResult, summary) {
      return "*Ticket Id* - ".concat(ticketId, " \n\nBitte finden Sie den Untersuchungsbericht unten.\n\n*Untersuchter Inhalt* - \nSicherheitsparameter - ").concat(overallResult, "\n\n").concat(summary, "\n\n`Vielen Dank f\xFCr Ihr Engagement f\xFCr die Online-Sicherheit.`");
    },
    russian: function russian(ticketId, overallResult, summary) {
      return "*Ticket Id* - ".concat(ticketId, " \n\n\u041D\u0438\u0436\u0435 \u043F\u0440\u0438\u0432\u0435\u0434\u0435\u043D \u043E\u0442\u0447\u0435\u0442 \u043E \u0440\u0430\u0441\u0441\u043B\u0435\u0434\u043E\u0432\u0430\u043D\u0438\u0438.\n\n*\u0418\u0441\u0441\u043B\u0435\u0434\u043E\u0432\u0430\u043D\u043D\u044B\u0439 \u043A\u043E\u043D\u0442\u0435\u043D\u0442* - \n\u041F\u0430\u0440\u0430\u043C\u0435\u0442\u0440 \u0431\u0435\u0437\u043E\u043F\u0430\u0441\u043D\u043E\u0441\u0442\u0438 - ").concat(overallResult, "\n\n").concat(summary, "\n\n`\u0421\u043F\u0430\u0441\u0438\u0431\u043E \u0437\u0430 \u0432\u0430\u0448\u0443 \u043F\u0440\u0438\u0432\u0435\u0440\u0436\u0435\u043D\u043D\u043E\u0441\u0442\u044C \u043E\u043D\u043B\u0430\u0439\u043D-\u0431\u0435\u0437\u043E\u043F\u0430\u0441\u043D\u043E\u0441\u0442\u0438.`");
    },
    chinese_simplified: function chinese_simplified(ticketId, overallResult, summary) {
      return "*Ticket Id* - ".concat(ticketId, " \n\n\u8BF7\u67E5\u6536\u4EE5\u4E0B\u8C03\u67E5\u62A5\u544A\u3002\n\n*\u8C03\u67E5\u5185\u5BB9* - \n\u5B89\u5168\u53C2\u6570 - ").concat(overallResult, "\n\n").concat(summary, "\n\n`\u611F\u8C22\u60A8\u5BF9\u7F51\u7EDC\u5B89\u5168\u7684\u627F\u8BFA\u3002`");
    },
    chinese_traditional: function chinese_traditional(ticketId, overallResult, summary) {
      return "*Ticket Id* - ".concat(ticketId, " \n\n\u8ACB\u67E5\u6536\u4EE5\u4E0B\u8ABF\u67E5\u5831\u544A\u3002\n\n*\u8ABF\u67E5\u5167\u5BB9* - \n\u5B89\u5168\u53C3\u6578 - ").concat(overallResult, "\n\n").concat(summary, "\n\n`\u611F\u8B1D\u60A8\u5C0D\u7DB2\u7D61\u5B89\u5168\u7684\u627F\u8AFE\u3002`");
    }
  }
};
function getLanguageFormattedMessage(messageType, preferedLanguage, params) {
  return new Promise(function (resolve, reject) {
    try {
      var message;
      var language = typeof preferedLanguage === 'string' && preferedLanguage.length > 0 ? preferedLanguage.toLowerCase() : 'english';
      if (messageType === "acknowledgment") {
        message = messages.acknowledgmentMessage[language] ? messages.acknowledgmentMessage[language](params.ticketId) : messages.acknowledgmentMessage.english(params.ticketId);
      } else if (messageType === "investigation") {
        message = messages.investigationMessage[language] ? messages.investigationMessage[language](params.ticketId, params.overallResult, params.summary) : messages.investigationMessage.english(params.ticketId, params.overallResult, params.summary);
      } else {
        return reject(new Error("Invalid message type"));
      }
      resolve(message);
    } catch (error) {
      reject(error);
    }
  });
}
var _default = getLanguageFormattedMessage;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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