"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.licenceCheck = void 0;
var _axios = _interopRequireDefault(require("axios"));
var _config = _interopRequireDefault(require("../config"));
var licenceCheck = function licenceCheck(licenceKey, date) {
  return new Promise(function (resolve, reject) {
    var newDate = new Date(new Date(date).setDate(new Date(date).getDate() + 14));
    try {
      var options = {
        method: 'get',
        url: "".concat(_config["default"].app.adminURL, "/api/v1/client/details?licenceKey=").concat(licenceKey),
        headers: {
          'Content-Type': 'application/json'
        }
      };
      (0, _axios["default"])(options).then(function (res) {
        return res.data;
      }).then(function (data) {
        resolve(data !== null && data !== void 0 && data.client ? data.client : {
          userLimit: 10,
          domainLimit: 1,
          expiresAt: newDate
        });
      })["catch"](function (err) {
        console.log(err);
        resolve({
          userLimit: 10,
          domainLimit: 1,
          expiresAt: newDate
        });
      });
    } catch (err) {
      console.log(err);
      resolve({
        userLimit: 10,
        domainLimit: 1,
        expiredAt: newDate
      });
    }
  });
};
exports.licenceCheck = licenceCheck;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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