"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _path = _interopRequireDefault(require("path"));
var _googleapis = require("googleapis");
var getAuthentication = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(fileName, email) {
    var authClient, gmail;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          authClient = new _googleapis.google.auth.JWT({
            keyFile: _path["default"].join(appRoot, 'Content', 'Credentials', fileName),
            scopes: ['https://mail.google.com/', 'https://www.googleapis.com/auth/admin.directory.user'],
            subject: email
          });
          _context.next = 3;
          return authClient.authorize();
        case 3:
          gmail = new _googleapis.gmail_v1.Gmail({
            auth: authClient
          });
          return _context.abrupt("return", {
            gmail: gmail,
            authClient: authClient
          });
        case 5:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return function getAuthentication(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();
var moveEmailTrash = function moveEmailTrash(_ref2) {
  var email = _ref2.email,
    messageId = _ref2.messageId,
    threadId = _ref2.threadId,
    fileName = _ref2.fileName;
  return new Promise( /*#__PURE__*/function () {
    var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(resolve, reject) {
      var _yield$getAuthenticat, gmail, authClient, result;
      return _regenerator["default"].wrap(function _callee2$(_context2) {
        while (1) switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return getAuthentication(fileName, email);
          case 2:
            _yield$getAuthenticat = _context2.sent;
            gmail = _yield$getAuthenticat.gmail;
            authClient = _yield$getAuthenticat.authClient;
            _context2.next = 7;
            return gmail.users.messages.modify({
              id: threadId || messageId,
              auth: authClient,
              userId: email,
              requestBody: {
                "addLabelIds": ["TRASH"],
                "removeLabelIds": ["INBOX"]
              }
            });
          case 7:
            result = _context2.sent;
            resolve(result);
          case 9:
          case "end":
            return _context2.stop();
        }
      }, _callee2);
    }));
    return function (_x3, _x4) {
      return _ref3.apply(this, arguments);
    };
  }());
};
var moveEmailDelete = function moveEmailDelete(_ref4) {
  var email = _ref4.email,
    messageId = _ref4.messageId,
    threadId = _ref4.threadId,
    fileName = _ref4.fileName;
  return new Promise( /*#__PURE__*/function () {
    var _ref5 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(resolve, reject) {
      var _yield$getAuthenticat2, gmail, authClient, result;
      return _regenerator["default"].wrap(function _callee3$(_context3) {
        while (1) switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return getAuthentication(fileName, email);
          case 2:
            _yield$getAuthenticat2 = _context3.sent;
            gmail = _yield$getAuthenticat2.gmail;
            authClient = _yield$getAuthenticat2.authClient;
            _context3.next = 7;
            return gmail.users.messages["delete"]({
              id: threadId || messageId,
              auth: authClient,
              userId: email
            });
          case 7:
            result = _context3.sent;
            resolve(result);
          case 9:
          case "end":
            return _context3.stop();
        }
      }, _callee3);
    }));
    return function (_x5, _x6) {
      return _ref5.apply(this, arguments);
    };
  }());
};
var moveEmailInbox = function moveEmailInbox(_ref6) {
  var email = _ref6.email,
    messageId = _ref6.messageId,
    threadId = _ref6.threadId,
    fileName = _ref6.fileName;
  return new Promise( /*#__PURE__*/function () {
    var _ref7 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(resolve, reject) {
      var _yield$getAuthenticat3, gmail, authClient, result;
      return _regenerator["default"].wrap(function _callee4$(_context4) {
        while (1) switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return getAuthentication(fileName, email);
          case 2:
            _yield$getAuthenticat3 = _context4.sent;
            gmail = _yield$getAuthenticat3.gmail;
            authClient = _yield$getAuthenticat3.authClient;
            _context4.next = 7;
            return gmail.users.messages.modify({
              id: threadId || messageId,
              auth: authClient,
              userId: email,
              requestBody: {
                "addLabelIds": ["INBOX"],
                "removeLabelIds": ["TRASH"]
              }
            });
          case 7:
            result = _context4.sent;
            resolve(result);
          case 9:
          case "end":
            return _context4.stop();
        }
      }, _callee4);
    }));
    return function (_x7, _x8) {
      return _ref7.apply(this, arguments);
    };
  }());
};
var _default = {
  processMoveEmailTrash: function processMoveEmailTrash(data) {
    return moveEmailTrash(data);
  },
  processMoveEmailDelete: function processMoveEmailDelete(data) {
    return moveEmailDelete(data);
  },
  processMoveEmailInbox: function processMoveEmailInbox(data) {
    return moveEmailInbox(data);
  }
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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