"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _axios = _interopRequireDefault(require("axios"));
var _config = _interopRequireDefault(require("../config"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var outlookBatchProcess = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(requests, token) {
    var data, axiosRequestConfig, response, result;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          data = {
            requests: requests
          };
          axiosRequestConfig = _objectSpread({
            method: 'POST',
            url: 'https://graph.microsoft.com/v1.0/$batch/',
            headers: {
              "content-type": "application/json",
              authorization: "Bearer ".concat(token),
              Prefer: 'outlook.allow-unsafe-operations'
            },
            data: JSON.stringify(data)
          }, _config["default"].proxy.enableForMicrosoftGraph && {
            httpsAgent: _config["default"].proxy.proxyAgent,
            httpAgent: _config["default"].proxy.proxyAgent
          });
          _context.next = 4;
          return _axios["default"].request(axiosRequestConfig);
        case 4:
          response = _context.sent;
          result = response.data.responses;
          return _context.abrupt("return", result);
        case 7:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return function outlookBatchProcess(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();
var moveEmailTrash = function moveEmailTrash(whoElseBatches) {
  return new Promise( /*#__PURE__*/function () {
    var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(resolve, reject) {
      var trashRequests, i, moveToTrashApi, moveToTrashReq, trashResponses;
      return _regenerator["default"].wrap(function _callee2$(_context2) {
        while (1) switch (_context2.prev = _context2.next) {
          case 0:
            trashRequests = [];
            for (i = 0; i < whoElseBatches.length; i++) {
              moveToTrashApi = "/users/".concat(whoElseBatches[i].email, "/messages/").concat(whoElseBatches[i].messageId, "/move");
              moveToTrashReq = {
                id: whoElseBatches[i].id,
                method: 'POST',
                url: moveToTrashApi,
                headers: {
                  "Authorization": "Bearer ".concat(whoElseBatches[i].token),
                  "Content-Type": "application/json"
                },
                body: {
                  "destinationId": "deleteditems"
                }
              };
              trashRequests.push(moveToTrashReq);
            }
            trashResponses = [];
            _context2.next = 5;
            return outlookBatchProcess(trashRequests, whoElseBatches[0].token);
          case 5:
            trashResponses = _context2.sent;
            resolve(trashResponses);
          case 7:
          case "end":
            return _context2.stop();
        }
      }, _callee2);
    }));
    return function (_x3, _x4) {
      return _ref2.apply(this, arguments);
    };
  }());
};
var moveEmailDelete = function moveEmailDelete(whoElseBatches) {
  return new Promise( /*#__PURE__*/function () {
    var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(resolve, reject) {
      var deleteRequests, i, deleteApi, deleteReq, deleteResponses;
      return _regenerator["default"].wrap(function _callee3$(_context3) {
        while (1) switch (_context3.prev = _context3.next) {
          case 0:
            deleteRequests = [];
            for (i = 0; i < whoElseBatches.length; i++) {
              deleteApi = "/users/".concat(whoElseBatches[i].email, "/messages/").concat(whoElseBatches[i].messageId);
              deleteReq = {
                id: whoElseBatches[i].id,
                method: 'DELETE',
                url: deleteApi,
                headers: {
                  "Authorization": "Bearer ".concat(whoElseBatches[i].token),
                  "Content-Type": "application/json"
                }
              };
              deleteRequests.push(deleteReq);
            }
            deleteResponses = [];
            _context3.next = 5;
            return outlookBatchProcess(deleteRequests, whoElseBatches[0].token);
          case 5:
            deleteResponses = _context3.sent;
            resolve(deleteResponses);
          case 7:
          case "end":
            return _context3.stop();
        }
      }, _callee3);
    }));
    return function (_x5, _x6) {
      return _ref3.apply(this, arguments);
    };
  }());
};
var moveEmailInbox = function moveEmailInbox(whoElseBatches) {
  return new Promise( /*#__PURE__*/function () {
    var _ref4 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(resolve, reject) {
      var recoverRequests, i, folderId, moveToInboxApi, moveToInboxReq, recoverResponses;
      return _regenerator["default"].wrap(function _callee4$(_context4) {
        while (1) switch (_context4.prev = _context4.next) {
          case 0:
            recoverRequests = [];
            for (i = 0; i < whoElseBatches.length; i++) {
              folderId = whoElseBatches ? whoElseBatches[i].folderId ? whoElseBatches[i].folderId : 'inbox' : 'inbox';
              moveToInboxApi = "/users/".concat(whoElseBatches[i].email, "/messages/").concat(whoElseBatches[i].messageId, "/move");
              moveToInboxReq = {
                id: whoElseBatches[i].id,
                method: 'POST',
                url: moveToInboxApi,
                headers: {
                  "Authorization": "Bearer ".concat(whoElseBatches[i].token),
                  "Content-Type": "application/json"
                },
                body: {
                  "destinationId": folderId
                }
              };
              recoverRequests.push(moveToInboxReq);
            }
            recoverResponses = [];
            _context4.next = 5;
            return outlookBatchProcess(recoverRequests, whoElseBatches[0].token);
          case 5:
            recoverResponses = _context4.sent;
            resolve(recoverResponses);
          case 7:
          case "end":
            return _context4.stop();
        }
      }, _callee4);
    }));
    return function (_x7, _x8) {
      return _ref4.apply(this, arguments);
    };
  }());
};
var _default = {
  processMoveEmailTrash: function processMoveEmailTrash(data) {
    return moveEmailTrash(data);
  },
  processMoveEmailDelete: function processMoveEmailDelete(data) {
    return moveEmailDelete(data);
  },
  processMoveEmailInbox: function processMoveEmailInbox(data) {
    return moveEmailInbox(data);
  }
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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