"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSenderEmail = exports.getOriginalMessageDetails = exports.getAttachments = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _axios = _interopRequireDefault(require("axios"));
var _config = _interopRequireDefault(require("../config"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
/**
 * Fetch attachments from an email.
 */
var getAttachments = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(email, messageId, accessToken) {
    var response, _error$response;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return _axios["default"].get("https://graph.microsoft.com/v1.0/users/".concat(email, "/messages/").concat(messageId, "/attachments"), _objectSpread({
            headers: {
              Authorization: "Bearer ".concat(accessToken),
              Accept: "application/json"
            }
          }, _config["default"].proxy.enableForMicrosoftGraph && {
            httpsAgent: _config["default"].proxy.proxyAgent,
            httpAgent: _config["default"].proxy.proxyAgent
          }));
        case 3:
          response = _context.sent;
          if (!(!response.data || !response.data.value.length)) {
            _context.next = 7;
            break;
          }
          console.warn("No attachments found for message: ".concat(messageId));
          return _context.abrupt("return", []);
        case 7:
          return _context.abrupt("return", response.data.value.map(function (attachment) {
            return {
              Id: attachment.id,
              Name: attachment.name || "unknown",
              ContentType: attachment.contentType || "application/octet-stream",
              ContentBytes: attachment.contentBytes ? Buffer.from(attachment.contentBytes, 'base64') : null
            };
          }));
        case 10:
          _context.prev = 10;
          _context.t0 = _context["catch"](0);
          console.error("Error fetching attachments:", ((_error$response = _context.t0.response) === null || _error$response === void 0 ? void 0 : _error$response.data) || _context.t0.message);
          return _context.abrupt("return", []);
        case 14:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 10]]);
  }));
  return function getAttachments(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
exports.getAttachments = getAttachments;
var getOriginalMessageDetails = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(email, messageId, attachmentId, accessToken) {
    var response, _error$response2;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          _context2.next = 3;
          return _axios["default"].get("https://graph.microsoft.com/v1.0/users/".concat(email, "/messages/").concat(messageId, "/attachments/").concat(attachmentId, "/$value"), _objectSpread({
            headers: {
              Authorization: "Bearer ".concat(accessToken),
              Accept: "message/rfc822"
            },
            responseType: 'arraybuffer'
          }, _config["default"].proxy.enableForMicrosoftGraph && {
            httpsAgent: _config["default"].proxy.proxyAgent,
            httpAgent: _config["default"].proxy.proxyAgent
          }));
        case 3:
          response = _context2.sent;
          return _context2.abrupt("return", response.data.toString('utf8'));
        case 7:
          _context2.prev = 7;
          _context2.t0 = _context2["catch"](0);
          console.error("Error fetching original message details:", ((_error$response2 = _context2.t0.response) === null || _error$response2 === void 0 ? void 0 : _error$response2.data) || _context2.t0.message);
          return _context2.abrupt("return", null);
        case 11:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 7]]);
  }));
  return function getOriginalMessageDetails(_x4, _x5, _x6, _x7) {
    return _ref2.apply(this, arguments);
  };
}();
exports.getOriginalMessageDetails = getOriginalMessageDetails;
var getSenderEmail = /*#__PURE__*/function () {
  var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(email, messageId, accessToken) {
    var getMessageUrl, response, senderEmail, _error$response3;
    return _regenerator["default"].wrap(function _callee3$(_context3) {
      while (1) switch (_context3.prev = _context3.next) {
        case 0:
          _context3.prev = 0;
          getMessageUrl = "https://graph.microsoft.com/v1.0/users/".concat(email, "/messages/").concat(messageId);
          _context3.next = 4;
          return _axios["default"].get(getMessageUrl, _objectSpread({
            headers: {
              Authorization: "Bearer ".concat(accessToken),
              Accept: "application/json"
            }
          }, _config["default"].proxy.enableForMicrosoftGraph && {
            httpsAgent: _config["default"].proxy.proxyAgent,
            httpAgent: _config["default"].proxy.proxyAgent
          }));
        case 4:
          response = _context3.sent;
          if (!(!response.data || !response.data.from || !response.data.from.emailAddress)) {
            _context3.next = 8;
            break;
          }
          console.error(" No valid sender information found in the email.");
          return _context3.abrupt("return", null);
        case 8:
          senderEmail = response.data.from.emailAddress.address;
          console.log("Extracted 'From' Email:", senderEmail);
          return _context3.abrupt("return", senderEmail);
        case 13:
          _context3.prev = 13;
          _context3.t0 = _context3["catch"](0);
          console.error("Error fetching email:", ((_error$response3 = _context3.t0.response) === null || _error$response3 === void 0 ? void 0 : _error$response3.data) || _context3.t0.message);
          return _context3.abrupt("return", null);
        case 17:
        case "end":
          return _context3.stop();
      }
    }, _callee3, null, [[0, 13]]);
  }));
  return function getSenderEmail(_x8, _x9, _x10) {
    return _ref3.apply(this, arguments);
  };
}();
exports.getSenderEmail = getSenderEmail;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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