"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _parseDomains = _interopRequireDefault(require("parse-domains"));
var _getIp = _interopRequireDefault(require("./get-ip"));
var _parseEmail = _interopRequireDefault(require("./parse-email"));
var getipAddress = function getipAddress(receivedHeaders) {
  var ip = null;
  receivedHeaders.forEach(function (header) {
    var match = header.match(/\b(?:\d{1,3}\.){3}\d{1,3}\b/);
    if (match) {
      ip = match[0];
    }
  });
  return ip;
};
var stringSearcher = function stringSearcher(str, key) {
  var keyList = [];
  if (typeof key === 'string') keyList.push(key);else if (Array.isArray(key)) keyList = key;
  if (str && str.length > 0) {
    if (key.length == 0) return 'fail';
    var filteredList = keyList.filter(function (iKey) {
      return str.indexOf(iKey) != -1;
    });
    if (filteredList.length > 0) {
      return 'pass';
    } else return 'fail';
  } else {
    return 'fail';
  }
};
var getParseHeader = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(header) {
    var status,
      investigate,
      parseEml,
      from,
      spfDomain,
      parsedDomain,
      fromDomain,
      dkimSiganture,
      search,
      filteredDkimSiganture,
      authResults,
      dkimDomain,
      _yield$getIp$processI,
      country,
      continent,
      _args = arguments;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          status = _args.length > 1 && _args[1] !== undefined ? _args[1] : true;
          _context.prev = 1;
          investigate = {};
          parseEml = header;
          if (!status) {
            _context.next = 8;
            break;
          }
          _context.next = 7;
          return _parseEmail["default"].parseHeader(header);
        case 7:
          parseEml = _context.sent;
        case 8:
          if (!(parseEml && parseEml.from)) {
            _context.next = 44;
            break;
          }
          from = parseEml.from[0].address;
          spfDomain = parseEml.headers['return-path'] ? Array.isArray(parseEml.headers['return-path']) ? parseEml.headers['return-path'][0].split("@")[1] : parseEml.headers['return-path'].split("@")[1] : null;
          parsedDomain = from.split('@')[1];
          fromDomain = parsedDomain;
          investigate['spfAllignment'] = fromDomain == spfDomain;
          dkimSiganture = parseEml.headers['dkim-signature'];
          if (Array.isArray(dkimSiganture)) {
            search = "d=".concat(fromDomain);
            filteredDkimSiganture = dkimSiganture.filter(function (r) {
              return r.includes(search);
            });
            if (filteredDkimSiganture.length > 0) dkimSiganture = filteredDkimSiganture[0];else if (dkimSiganture > 0) dkimSiganture = dkimSiganture[0];else dkimSiganture = null;
          }
          authResults = parseEml.headers['authentication-results'];
          authResults = Array.isArray(authResults) && authResults.length > 0 ? authResults.filter(function (r) {
            return r.startsWith('amazonses.com');
          }).join(" ") : authResults;
          dkimDomain = dkimSiganture && dkimSiganture != null ? function () {
            var dIndex = dkimSiganture.search(/d=.*?;/);
            var dValue = dkimSiganture.slice(dIndex + 2, dkimSiganture.indexOf(";", dIndex + 2));
            return dValue;
          }() : null;
          if (!dkimDomain) {
            _context.next = 25;
            break;
          }
          _context.next = 22;
          return (0, _parseDomains["default"])(dkimDomain);
        case 22:
          _context.t0 = _context.sent;
          _context.next = 26;
          break;
        case 25:
          _context.t0 = null;
        case 26:
          parsedDomain = _context.t0;
          dkimDomain = parsedDomain ? "".concat(parsedDomain.domain) : dkimDomain;
          investigate['dkimAllignment'] = fromDomain == dkimDomain;
          _context.next = 31;
          return getipAddress(parseEml.headers['received']);
        case 31:
          investigate['senderIp'] = _context.sent;
          _context.next = 34;
          return _getIp["default"].processIp(investigate['senderIp']);
        case 34:
          _yield$getIp$processI = _context.sent;
          country = _yield$getIp$processI.country;
          continent = _yield$getIp$processI.continent;
          if (country && continent) {
            investigate['country'] = country;
            investigate['continent'] = continent;
          } else {
            investigate['country'] = 'NOT FOUND';
            investigate['continent'] = 'NOT FOUND';
          }
          investigate['spf'] = stringSearcher(authResults, 'spf=pass');
          investigate['dkim'] = stringSearcher(authResults, 'dkim=pass');
          investigate['dmarc'] = stringSearcher(authResults, ['dmarc=pass', 'dmarc=none']);
          return _context.abrupt("return", investigate);
        case 44:
          console.error('error from parsing header details');
          return _context.abrupt("return", {});
        case 46:
          _context.next = 52;
          break;
        case 48:
          _context.prev = 48;
          _context.t1 = _context["catch"](1);
          console.log(_context.t1);
          return _context.abrupt("return", {});
        case 52:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[1, 48]]);
  }));
  return function getParseHeader(_x) {
    return _ref.apply(this, arguments);
  };
}();
var _default = {
  processHeader: function processHeader(header, status) {
    return getParseHeader(header, status);
  }
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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