"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _credentials = _interopRequireDefault(require("./credentials"));
var _getGsuiteGroups = _interopRequireDefault(require("./get-gsuite-groups"));
var _getOutlookGroups = _interopRequireDefault(require("./get-outlook-groups"));
var _default = {
  process: function () {
    var _process = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(companyId, domainId, domainType, partialGroupName) {
      var creds;
      return _regenerator["default"].wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _context.prev = 0;
            _context.next = 3;
            return _credentials["default"].getCredentials(companyId, domainId);
          case 3:
            creds = _context.sent;
            if (!(domainType == 'Outlook')) {
              _context.next = 6;
              break;
            }
            return _context.abrupt("return", _getOutlookGroups["default"].processGroups(creds, partialGroupName));
          case 6:
            if (!(domainType == 'Gsuite')) {
              _context.next = 8;
              break;
            }
            return _context.abrupt("return", _getGsuiteGroups["default"].processGroups(creds, partialGroupName));
          case 8:
            _context.next = 15;
            break;
          case 10:
            _context.prev = 10;
            _context.t0 = _context["catch"](0);
            _context.next = 14;
            return db.Domain.updateOne({
              _id: domainId
            }, {
              isSyncingUser: false,
              syncEndAt: new Date(),
              isSyncingUserError: true,
              isSyncingUserErrorFile: JSON.stringify(_context.t0)
            });
          case 14:
            throw new RequestError('Invalid credentials', 429);
          case 15:
          case "end":
            return _context.stop();
        }
      }, _callee, null, [[0, 10]]);
    }));
    function process(_x, _x2, _x3, _x4) {
      return _process.apply(this, arguments);
    }
    return process;
  }()
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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