"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _credentials = _interopRequireDefault(require("./credentials"));
var _getGsuiteUsers = _interopRequireDefault(require("./get-gsuite-users"));
var _getOutlookUsers = _interopRequireDefault(require("./get-outlook-users"));
var _updateSyncingStatusGroups = require("./update-syncing-status-groups");
var _default = {
  process: function () {
    var _process = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(companyId, domainId, domainName, subDomainGroups, domainType, nextLink, isExchange, group, creds) {
      var isMirrorSync,
        allUsersGroupId,
        syncTs,
        pageIndex,
        nextPageToken,
        _args = arguments;
      return _regenerator["default"].wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            isMirrorSync = _args.length > 9 && _args[9] !== undefined ? _args[9] : false;
            allUsersGroupId = _args.length > 10 && _args[10] !== undefined ? _args[10] : null;
            syncTs = _args.length > 11 && _args[11] !== undefined ? _args[11] : new Date();
            pageIndex = _args.length > 12 && _args[12] !== undefined ? _args[12] : 0;
            _context.prev = 4;
            if (!(domainType == 'Outlook')) {
              _context.next = 7;
              break;
            }
            return _context.abrupt("return", _getOutlookUsers["default"].processUser(domainId, domainName, subDomainGroups, companyId, creds, nextLink, isExchange, group, isMirrorSync, allUsersGroupId, syncTs, pageIndex));
          case 7:
            if (!(domainType == 'Gsuite')) {
              _context.next = 10;
              break;
            }
            nextPageToken = null;
            return _context.abrupt("return", _getGsuiteUsers["default"].processUser(domainId, domainName, subDomainGroups, companyId, creds, nextPageToken, group, isMirrorSync, allUsersGroupId, syncTs, pageIndex));
          case 10:
            _context.next = 20;
            break;
          case 12:
            _context.prev = 12;
            _context.t0 = _context["catch"](4);
            console.log("Error in processUser:", _context.t0);
            _context.next = 17;
            return (0, _updateSyncingStatusGroups.updateSyncingStatusOfGroups)(group._id, companyId);
          case 17:
            _context.next = 19;
            return db.Domain.updateOne({
              _id: domainId
            }, {
              isSyncingUser: false,
              syncEndAt: new Date(),
              isSyncingUserError: true,
              isSyncingUserErrorFile: JSON.stringify(_context.t0)
            });
          case 19:
            throw new RequestError('Invalid credentials', 429);
          case 20:
          case "end":
            return _context.stop();
        }
      }, _callee, null, [[4, 12]]);
    }));
    function process(_x, _x2, _x3, _x4, _x5, _x6, _x7, _x8, _x9) {
      return _process.apply(this, arguments);
    }
    return process;
  }()
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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