"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _config = _interopRequireDefault(require("../config"));
var fs = require('fs');
var axios = require('axios');
var path = require('path');
// OpenAI API Key
var api_key = _config["default"].openai.key;

// Function to encode the image
function encodeImage(imagePath) {
  var image = fs.readFileSync(imagePath);
  return Buffer.from(image).toString('base64');
}
var process = function process(fileName) {
  var preferedLanguage = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'english';
  console.log("Process Message function ==>==>==> Processing file:", fileName, "with preferred language:", preferedLanguage);
  return new Promise(function (resolve, reject) {
    try {
      var imagePath = path.join(appRoot, 'Content', 'whatsappImages', fileName);
      var base64Image = encodeImage(imagePath);
      var headers = {
        "Content-Type": "application/json",
        "Authorization": "Bearer ".concat(api_key)
      };

      // const payload = {
      // "model": "gpt-4-turbo",
      // "messages": [
      //     {
      //     "role": "user",
      //     "content": [
      //         {
      //         "type": "text",
      //         // "text": `Your Task: I am sending you image of text messages. I want you to ignore partially visible messages in the screenshot but analyse the fully visible messages, and segregate each message into a block(a key value JS object). This message must have the following keys only( Sender, Message Body, Safety Parameter, Description, Links). Here, safety parameter can have values 'safe','dubious' or 'unsafe' which should be deco, Description key should contain a brief reasoning of why it is it marked so and Links is the key that should be an array of links that were present in that message(it should be empty when no links are present in the message). I want you to include the previous mentioned details in an array of each blocks. Additionally I want you to send another array containing an object that has key 'descision' based on overall conversation's safety which you must evalute by parsing whole conversation(valid values are 'safe','dubious' or 'unsafe') only, I dont want any explanation for the overall. Wrap these two arrays in a singleArray. [Must keep in points]: 1. If message has a highlighted part, strictly ignore the non highlighted text. 2. You should include fully visible messages only. 3. The format should not be json or a codeblock.... [[{ block1 details}, { block2 details}...], [{ decision}]] where a block has shape { "Sender": string, "Message Body": string, "Safety Parameter", 'Description', 'Links'}. 4. Strictly stick to this format, do not add any message from your side 5. I want you restrict these output length to 1024 and you are allowed to abbreviate message body such as (starting words ..... end Words).`
      //         "text": `Your Task: I am sending you an image of text messages. Ignore partially visible messages in the screenshot and analyze only fully visible messages. Segregate each message into a block (a key-value JavaScript object). Each message must have the following keys only:  - **Sender** (string)   - **Message Body** (string, abbreviated if necessary)   - **Safety Parameter** (strictly one of: 'safe', 'dubious', or 'unsafe' in the **same language** as the message text)   - **Description** (brief reasoning for classification in the **same language** as the message text)   - **Links** (array of links found in the message; empty if none)    Include these details in an **array of message blocks**. Additionally, provide another array containing an object with the key 'decision', which represents the **overall conversation safety evaluation**. The **decision** value must also be in the **same language** as the message text.  ### **Important Context-Based Analysis:**   1. **Analyze Full Conversation First:** Read the **entire conversation** before classifying individual messages.   2. **Context-Aware Message Analysis:** If a message's meaning or safety depends on another message, **consider the related messages before making a decision.**   3. **Language Matching Rule:** The entire output, including 'Safety Parameter' and 'Description', must be in the **same language** as the text in the image.   4. **Highlighted Text Rule:** If a message has a highlighted part, strictly ignore the non-highlighted text.   5. **Message Visibility Rule:** Process only fully visible messages; ignore cut-off texts.   6. **Format Rule:** The response **must** be in this exact structure (no JSON, no extra text):      [[{ block1 details }, { block2 details }...], [{ decision }]]      Each block follows:      { "Sender": "...", "Message Body": "...", "Safety Parameter": "...", "Description": "...", "Links": [...] }   7. **Output Length Limit:** Keep responses **under 1024 characters**. If needed, abbreviate the **Message Body** (e.g., "Starting words...ending words").   8. **Consistency Rule:** Apply the same safety classification logic across runs to avoid different results for the same message.   9. **No Extra Text:** Do **not** add explanations, apologies, or introductory phrases—only return the structured response.`  
      //     }
      //     ]
      //     },
      //     {
      //     "role": "user",
      //     "content": [
      //         {
      //         "type": "image_url",
      //         "image_url": {
      //             "url": `data:image/jpeg;base64,${base64Image}`
      //         }
      //         }
      //     ]
      //     }
      // ],
      // "max_tokens": 4096
      // };
      console.log("preferredLanguage before payload---------", preferedLanguage);
      var payload = {
        "model": "gpt-4-turbo",
        "messages": [{
          "role": "user",
          "content": [
          // {
          //     "type": "text",
          //     "text": `Your Task: I am sending you an image of text messages. Ignore partially visible messages in the screenshot and analyze only fully visible messages. Segregate each message into a block (a key-value JavaScript object). Each message must have the following keys only:  

          //     - **Sender** (string)  
          //     - **Message Body** (string, abbreviated if necessary)  
          //     - **Safety Parameter** (**strictly one of:** translated equivalents of 'safe', or 'potentially unsafe' in the **same language** as the message text)  
          //     - **Description** (brief reasoning for classification in the **same language** as the message text)  
          //     - **Links** (array of links found in the message; empty if none)  

          //     Include these details in an **array of message blocks**. Additionally, provide another array containing an object with the key 'decision', which represents the **overall conversation safety evaluation**. The **decision** value must also be in the **same language** as the message text.  

          //     ### **Important Context-Based Analysis:**  
          //     1. **Analyze Full Conversation First:** Read the **entire conversation** before classifying individual messages.  
          //     2. **Context-Aware Message Analysis:** If a message's meaning or safety depends on another message, **consider the related messages before making a decision.**  
          //     3. **Language-Adaptive Safety Labels:** Translate 'safe', 'dubious', and 'unsafe' into the detected language of the messages and use them consistently.  
          //     4. **Highlighted Text Rule:** If a message has a highlighted part, strictly ignore the non-highlighted text.  
          //     5. **Message Visibility Rule:** Process only fully visible messages; ignore cut-off texts.  
          //     6. **Format Rule:** The response **must** be in this exact structure (no JSON, no extra text):  

          //        [[{ block1 details }, { block2 details }...], [{ decision }]]  

          //        Each block follows:  

          //        { "Sender": "...", "Message Body": "...", "Safety Parameter": "...", "Description": "...", "Links": [...] }  

          //     7. **Output Length Limit:** Keep responses **under 1024 characters**. If needed, abbreviate the **Message Body** (e.g., "Starting words...ending words").  
          //     8. **Consistency Rule:** Apply the same safety classification logic across runs to avoid different results for the same message.  
          //     9. **No Extra Text:** Do **not** add explanations, apologies, or introductory phrases—only return the structured response.`
          // }
          {
            "type": "text",
            "text": "IMPORTANT: Keep the following field names exactly in English \u2014 Sender, Message Body, Safety Parameter, Description, Links, decision, summary. Translate ONLY the field VALUES into ".concat(preferedLanguage, ". If any value or free-text appears in another language, your response will be rejected.\n                                        \n                                Your Task: I am sending you an image of text messages. Ignore partially visible messages in the screenshot and analyze only fully visible messages. Segregate each message into a block (a key-value JavaScript object). Each message must have the following keys only:               \n                                - **Sender** (string)  \n                                - **Message Body** (string, abbreviated if necessary)  \n                                - **Safety Parameter** (**strictly one of:** translated equivalents of 'safe', or 'potentially unsafe' in ").concat(preferedLanguage, " )  \n                                - **Description** (brief reasoning for classification in ").concat(preferedLanguage, " )  \n                                - **Links** (array of links found in the message; empty if none)  \n                            \n                                Include these details in an **array of message blocks**. Additionally, provide another array containing an object with the following keys:  \n                            \n                                - **decision** \u2013 The **overall conversation safety evaluation** in ").concat(preferedLanguage, ".  \n                                - **summary** \u2013 A **single concise description** summarizing the **entire conversation's context and safety evaluation**, similar to this example for an unsafe conversation:  \n                                  *No, do not click the link in this message. This is a phishing attempt. The message pretends to be from Bank BRI, asking you to click a link to confirm or activate something related to tariffs or banking services. However, the link (zyrosite.com) is not a legitimate domain associated with Bank BRI and is likely designed to steal personal information or install malware.*  \n                            \n                                ### **Important Context-Based Analysis:**  \n                                1. **Analyze Full Conversation First:** Read the **entire conversation** before classifying individual messages.  \n                                2. **Context-Aware Message Analysis:** If a message's meaning or safety depends on another message, **consider the related messages before making a decision.**  \n                                3. **Language-Adaptive Safety Labels:** Translate 'safe', 'dubious', and 'unsafe' into the detected language of the messages and use them consistently.  \n                                4. **Highlighted Text Rule:** If a message has a highlighted part, strictly ignore the non-highlighted text.  \n                                5. **Message Visibility Rule:** Process only fully visible messages; ignore cut-off texts.  \n                                6. **Format Rule:** The response **must** be in this exact structure (no JSON, no extra text):  \n                            \n                                   **[[{ block1 details }, { block2 details }...], [{ decision, summary }]]**  \n                            \n                                   Each block follows:  \n                            \n                                   { \"Sender\": \"...\", \"Message Body\": \"...\", \"Safety Parameter\": \"...\", \"Description\": \"...\", \"Links\": [...] }  \n                            \n                                7. **Output Length Limit:** Keep responses **under 1024 characters**. If needed, abbreviate the **Message Body** (e.g., \"Starting words...ending words\").  \n                                8. **Consistency Rule:** Apply the same safety classification logic across runs to avoid different results for the same message.  \n                                9. **No Extra Text:** Do **not** add explanations, apologies, or introductory phrases\u2014only return the structured response.")
          }]
        }, {
          "role": "user",
          "content": [{
            "type": "image_url",
            "image_url": {
              "url": "data:image/jpeg;base64,".concat(base64Image)
            }
          }]
        }],
        "max_tokens": 4096
      };
      axios.post("https://api.openai.com/v1/chat/completions", payload, {
        headers: headers
      }).then(function (response) {
        if (response && response.data && response.data.choices && response.data.choices.length) resolve(response.data.choices[0].message);else resolve(false);
      })["catch"](function (error) {
        console.error('Error:', error.response.data);
      });
    } catch (err) {
      console.error(err);
      reject(err);
    }
  });
};
var _default = {
  processMessage: function () {
    var _processMessage = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(fileName, preferedLanguage) {
      return _regenerator["default"].wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            return _context.abrupt("return", process(fileName, preferedLanguage));
          case 1:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    function processMessage(_x, _x2) {
      return _processMessage.apply(this, arguments);
    }
    return processMessage;
  }()
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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