"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveImage = saveImage;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _axios = _interopRequireDefault(require("axios"));
var _fs = _interopRequireDefault(require("fs"));
var _config = _interopRequireDefault(require("../config"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function saveImage(_x, _x2, _x3) {
  return _saveImage.apply(this, arguments);
}
function _saveImage() {
  _saveImage = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(uri, filePath, accessToken) {
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          return _context.abrupt("return", new Promise(function (resolve, reject) {
            console.log("Inside saveImage --", uri);
            (0, _axios["default"])(_objectSpread({
              method: "GET",
              url: uri,
              headers: {
                Authorization: "Bearer ".concat(accessToken)
              },
              responseType: "stream"
            }, _config["default"].proxy.enableForWhatsapp && {
              httpsAgent: _config["default"].proxy.proxyAgent,
              httpAgent: _config["default"].proxy.proxyAgent
            })).then(function (response) {
              response.data.pipe(_fs["default"].createWriteStream(filePath)).on("finish", function () {
                console.log("Image saved successfully at", filePath);
                resolve(true);
              }).on("error", function (err) {
                console.log("Error while saving image:", err);
                reject(err);
              });
            })["catch"](function (err) {
              console.log("Error while downloading image:", err);
              resolve(false);
            });
          }));
        case 1:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return _saveImage.apply(this, arguments);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJzYXZlSW1hZ2UiLCJ1cmkiLCJmaWxlUGF0aCIsImFjY2Vzc1Rva2VuIiwiUHJvbWlzZSIsInJlc29sdmUiLCJyZWplY3QiLCJjb25zb2xlIiwibG9nIiwiYXhpb3MiLCJtZXRob2QiLCJ1cmwiLCJoZWFkZXJzIiwiQXV0aG9yaXphdGlvbiIsInJlc3BvbnNlVHlwZSIsImNvbmZpZyIsInByb3h5IiwiZW5hYmxlRm9yV2hhdHNhcHAiLCJodHRwc0FnZW50IiwicHJveHlBZ2VudCIsImh0dHBBZ2VudCIsInRoZW4iLCJyZXNwb25zZSIsImRhdGEiLCJwaXBlIiwiZnMiLCJjcmVhdGVXcml0ZVN0cmVhbSIsIm9uIiwiZXJyIl0sInNvdXJjZXMiOlsiLi4vLi4vc3JjL3NlcnZpY2Uvc2F2ZVdoYXRzYXBwSW1hZ2UuanMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IGF4aW9zIGZyb20gJ2F4aW9zJztcbmltcG9ydCBmcyBmcm9tICdmcyc7XG5pbXBvcnQgY29uZmlnIGZyb20gJy4uL2NvbmZpZyc7XG5cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBzYXZlSW1hZ2UodXJpLCBmaWxlUGF0aCwgYWNjZXNzVG9rZW4pIHtcbiAgcmV0dXJuIG5ldyBQcm9taXNlKChyZXNvbHZlLCByZWplY3QpID0+IHtcbiAgICBjb25zb2xlLmxvZyhcIkluc2lkZSBzYXZlSW1hZ2UgLS1cIiwgdXJpKTtcbiAgICBheGlvcyh7XG4gICAgICBtZXRob2Q6IFwiR0VUXCIsXG4gICAgICB1cmw6IHVyaSxcbiAgICAgIGhlYWRlcnM6IHsgQXV0aG9yaXphdGlvbjogYEJlYXJlciAke2FjY2Vzc1Rva2VufWAgfSxcbiAgICAgIHJlc3BvbnNlVHlwZTogXCJzdHJlYW1cIixcbiAgICAgIC4uLihjb25maWcucHJveHkuZW5hYmxlRm9yV2hhdHNhcHAgJiYgeyBodHRwc0FnZW50OiBjb25maWcucHJveHkucHJveHlBZ2VudCwgaHR0cEFnZW50OiBjb25maWcucHJveHkucHJveHlBZ2VudCB9KVxuICAgIH0pXG4gICAgICAudGhlbihyZXNwb25zZSA9PiB7XG4gICAgICAgIHJlc3BvbnNlLmRhdGFcbiAgICAgICAgICAucGlwZShmcy5jcmVhdGVXcml0ZVN0cmVhbShmaWxlUGF0aCkpXG4gICAgICAgICAgLm9uKFwiZmluaXNoXCIsICgpID0+IHtcbiAgICAgICAgICAgIGNvbnNvbGUubG9nKFwiSW1hZ2Ugc2F2ZWQgc3VjY2Vzc2Z1bGx5IGF0XCIsIGZpbGVQYXRoKTtcbiAgICAgICAgICAgIHJlc29sdmUodHJ1ZSk7XG4gICAgICAgICAgfSlcbiAgICAgICAgICAub24oXCJlcnJvclwiLCAoZXJyKSA9PiB7XG4gICAgICAgICAgICBjb25zb2xlLmxvZyhcIkVycm9yIHdoaWxlIHNhdmluZyBpbWFnZTpcIiwgZXJyKTtcbiAgICAgICAgICAgIHJlamVjdChlcnIpO1xuICAgICAgICAgIH0pO1xuICAgICAgfSlcbiAgICAgIC5jYXRjaCgoZXJyKSA9PiB7XG4gICAgICAgIGNvbnNvbGUubG9nKFwiRXJyb3Igd2hpbGUgZG93bmxvYWRpbmcgaW1hZ2U6XCIsIGVycik7XG4gICAgICAgIHJlc29sdmUoZmFsc2UpO1xuICAgICAgfSk7XG4gIH0pO1xufVxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQStCO0FBQUE7QUFBQSxTQUVUQSxTQUFTO0VBQUE7QUFBQTtBQUFBO0VBQUEsMkZBQXhCLGlCQUF5QkMsR0FBRyxFQUFFQyxRQUFRLEVBQUVDLFdBQVc7SUFBQTtNQUFBO1FBQUE7VUFBQSxpQ0FDakQsSUFBSUMsT0FBTyxDQUFDLFVBQUNDLE9BQU8sRUFBRUMsTUFBTSxFQUFLO1lBQ3RDQyxPQUFPLENBQUNDLEdBQUcsQ0FBQyxxQkFBcUIsRUFBRVAsR0FBRyxDQUFDO1lBQ3ZDLElBQUFRLGlCQUFLO2NBQ0hDLE1BQU0sRUFBRSxLQUFLO2NBQ2JDLEdBQUcsRUFBRVYsR0FBRztjQUNSVyxPQUFPLEVBQUU7Z0JBQUVDLGFBQWEsbUJBQVlWLFdBQVc7Y0FBRyxDQUFDO2NBQ25EVyxZQUFZLEVBQUU7WUFBUSxHQUNsQkMsa0JBQU0sQ0FBQ0MsS0FBSyxDQUFDQyxpQkFBaUIsSUFBSTtjQUFFQyxVQUFVLEVBQUVILGtCQUFNLENBQUNDLEtBQUssQ0FBQ0csVUFBVTtjQUFFQyxTQUFTLEVBQUVMLGtCQUFNLENBQUNDLEtBQUssQ0FBQ0c7WUFBVyxDQUFDLEVBQ2pILENBQ0NFLElBQUksQ0FBQyxVQUFBQyxRQUFRLEVBQUk7Y0FDaEJBLFFBQVEsQ0FBQ0MsSUFBSSxDQUNWQyxJQUFJLENBQUNDLGNBQUUsQ0FBQ0MsaUJBQWlCLENBQUN4QixRQUFRLENBQUMsQ0FBQyxDQUNwQ3lCLEVBQUUsQ0FBQyxRQUFRLEVBQUUsWUFBTTtnQkFDbEJwQixPQUFPLENBQUNDLEdBQUcsQ0FBQyw2QkFBNkIsRUFBRU4sUUFBUSxDQUFDO2dCQUNwREcsT0FBTyxDQUFDLElBQUksQ0FBQztjQUNmLENBQUMsQ0FBQyxDQUNEc0IsRUFBRSxDQUFDLE9BQU8sRUFBRSxVQUFDQyxHQUFHLEVBQUs7Z0JBQ3BCckIsT0FBTyxDQUFDQyxHQUFHLENBQUMsMkJBQTJCLEVBQUVvQixHQUFHLENBQUM7Z0JBQzdDdEIsTUFBTSxDQUFDc0IsR0FBRyxDQUFDO2NBQ2IsQ0FBQyxDQUFDO1lBQ04sQ0FBQyxDQUFDLFNBQ0ksQ0FBQyxVQUFDQSxHQUFHLEVBQUs7Y0FDZHJCLE9BQU8sQ0FBQ0MsR0FBRyxDQUFDLGdDQUFnQyxFQUFFb0IsR0FBRyxDQUFDO2NBQ2xEdkIsT0FBTyxDQUFDLEtBQUssQ0FBQztZQUNoQixDQUFDLENBQUM7VUFDTixDQUFDLENBQUM7UUFBQTtRQUFBO1VBQUE7TUFBQTtJQUFBO0VBQUEsQ0FDSDtFQUFBO0FBQUEifQ==