"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _axios = _interopRequireDefault(require("axios"));
var _kue = require("../kue");
var _config = _interopRequireDefault(require("../config"));
var scanAttachment = function scanAttachment(formData) {
  return new Promise( /*#__PURE__*/function () {
    var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(resolve, reject) {
      var request;
      return _regenerator["default"].wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            request = {
              method: 'post',
              url: 'https://www.virustotal.com/vtapi/v2/file/scan',
              data: formData
            };
            if (_config["default"].proxy.enableForVirusTotal) {
              request.httpsAgent = _config["default"].proxy.proxyAgent;
              request.httpAgent = _config["default"].proxy.proxyAgent;
            }
            _axios["default"].request(request).then(function (res) {
              return res.data;
            }).then(function (data) {
              resolve(data);
            })["catch"](function (err) {
              console.log(JSON.stringify(err));
              reject(err);
            });
          case 3:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function (_x, _x2) {
      return _ref.apply(this, arguments);
    };
  }());
};
var _default = {
  processScanAttachment: function () {
    var _processScanAttachment = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(formData, attachmentId, companyId) {
      return _regenerator["default"].wrap(function _callee3$(_context3) {
        while (1) switch (_context3.prev = _context3.next) {
          case 0:
            return _context3.abrupt("return", scanAttachment(formData).then(function (data) {
              console.log('attachments', {
                data: data
              });
              _kue.queue.create('attachment-report', {
                attachmentId: attachmentId,
                companyId: companyId,
                data: data
              }).attempts(5).delay(60000).backoff({
                type: 'exponential'
              }).removeOnComplete(true).save().on('failed', /*#__PURE__*/function () {
                var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(errorMessage) {
                  return _regenerator["default"].wrap(function _callee2$(_context2) {
                    while (1) switch (_context2.prev = _context2.next) {
                      case 0:
                        _context2.next = 2;
                        return db.Attachment.updateOne({
                          _id: attachmentId
                        }, {
                          status: 'FAILED'
                        });
                      case 2:
                      case "end":
                        return _context2.stop();
                    }
                  }, _callee2);
                }));
                return function (_x6) {
                  return _ref2.apply(this, arguments);
                };
              }());
              return db.Attachment.updateOne({
                _id: attachmentId
              }, {
                details: data,
                scanId: data.scan_id
              });
            })["catch"](function (err) {
              return db.Attachment.updateOne({
                _id: attachmentId
              }, {
                status: 'FAILED',
                result: JSON.stringify(err)
              });
            }));
          case 1:
          case "end":
            return _context3.stop();
        }
      }, _callee3);
    }));
    function processScanAttachment(_x3, _x4, _x5) {
      return _processScanAttachment.apply(this, arguments);
    }
    return processScanAttachment;
  }()
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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