"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _axios = _interopRequireDefault(require("axios"));
var _kue = require("../kue");
var _config = _interopRequireDefault(require("../config"));
var scanURL = function scanURL(data) {
  return new Promise( /*#__PURE__*/function () {
    var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(resolve, reject) {
      var request;
      return _regenerator["default"].wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            request = {
              method: 'post',
              url: 'https://www.virustotal.com/vtapi/v2/url/scan',
              data: data
            };
            if (_config["default"].proxy.enableForVirusTotal) {
              request.httpsAgent = _config["default"].proxy.proxyAgent;
              request.httpAgent = _config["default"].proxy.proxyAgent;
            }
            _axios["default"].request(request).then(function (res) {
              return res.data;
            }).then(function (data) {
              resolve(data);
            })["catch"](function (err) {
              console.log(JSON.stringify(err));
              reject(err);
            });
          case 3:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function (_x, _x2) {
      return _ref.apply(this, arguments);
    };
  }());
};
var _default = {
  processScanURL: function () {
    var _processScanURL = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(data, urlId, companyId) {
      return _regenerator["default"].wrap(function _callee2$(_context2) {
        while (1) switch (_context2.prev = _context2.next) {
          case 0:
            return _context2.abrupt("return", scanURL(data).then(function (data) {
              console.log('url', {
                data: data
              });
              _kue.queue.create('url-report', {
                urlId: urlId,
                data: data,
                companyId: companyId
              }).delay(30000).removeOnComplete(true).save();
              return db.Url.updateOne({
                _id: urlId
              }, {
                details: data,
                scanId: data.scan_id
              });
            })["catch"](function (err) {
              console.log('errrrrrrrrrrrrr', err);
              return db.Url.updateOne({
                _id: urlId
              }, {
                status: 'FAILED',
                details: JSON.stringify(err)
              });
            }));
          case 1:
          case "end":
            return _context2.stop();
        }
      }, _callee2);
    }));
    function processScanURL(_x3, _x4, _x5) {
      return _processScanURL.apply(this, arguments);
    }
    return processScanURL;
  }(),
  processScanWaURL: function () {
    var _processScanWaURL = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(data, urlId, companyId) {
      return _regenerator["default"].wrap(function _callee3$(_context3) {
        while (1) switch (_context3.prev = _context3.next) {
          case 0:
            return _context3.abrupt("return", scanURL(data).then(function (data) {
              console.log('url', {
                data: data
              });
              _kue.queue.create('url-wa-report', {
                urlId: urlId,
                data: data,
                companyId: companyId
              }).delay(30000).removeOnComplete(true).save();
              return db.Url.updateOne({
                _id: urlId
              }, {
                details: data,
                scanId: data.scan_id
              });
            })["catch"](function (err) {
              console.log('errrrrrrrrrrrrr', err);
              return db.Url.updateOne({
                _id: urlId
              }, {
                status: 'FAILED',
                details: JSON.stringify(err)
              });
            }));
          case 1:
          case "end":
            return _context3.stop();
        }
      }, _callee3);
    }));
    function processScanWaURL(_x6, _x7, _x8) {
      return _processScanWaURL.apply(this, arguments);
    }
    return processScanWaURL;
  }()
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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