"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMessageByInternetMessageId = exports.formatMailAttachments = exports.createSubscription = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _path = _interopRequireDefault(require("path"));
var _axios = _interopRequireDefault(require("axios"));
var _credentials = _interopRequireDefault(require("../service/credentials"));
var _config = _interopRequireDefault(require("../config"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var GRAPH_API_URL = "https://graph.microsoft.com/v1.0/subscriptions";
var MAX_SUBSCRIPTION_MINUTES = 10070;
var getExistingSubscription = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(email, token) {
    var response;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return _axios["default"].get(GRAPH_API_URL, _objectSpread({
            headers: {
              Authorization: "Bearer ".concat(token)
            }
          }, _config["default"].proxy.enableForMicrosoftGraph && {
            httpsAgent: _config["default"].proxy.proxyAgent,
            httpAgent: _config["default"].proxy.proxyAgent
          }));
        case 3:
          response = _context.sent;
          if (!(response.data && response.data.value)) {
            _context.next = 6;
            break;
          }
          return _context.abrupt("return", response.data.value.find(function (sub) {
            return sub.resource.includes(email);
          }));
        case 6:
          return _context.abrupt("return", null);
        case 9:
          _context.prev = 9;
          _context.t0 = _context["catch"](0);
          console.error("Error fetching existing subscriptions:", _context.t0.message);
          return _context.abrupt("return", null);
        case 13:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 9]]);
  }));
  return function getExistingSubscription(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();
var deleteSubscription = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(subscriptionId, token) {
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          _context2.next = 3;
          return _axios["default"]["delete"]("".concat(GRAPH_API_URL, "/").concat(subscriptionId), {
            headers: {
              Authorization: "Bearer ".concat(token)
            }
          });
        case 3:
          console.log("Deleted existing subscription: ".concat(subscriptionId));
          _context2.next = 9;
          break;
        case 6:
          _context2.prev = 6;
          _context2.t0 = _context2["catch"](0);
          console.error("Error deleting subscription ".concat(subscriptionId, ":"), _context2.t0.message);
        case 9:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 6]]);
  }));
  return function deleteSubscription(_x3, _x4) {
    return _ref2.apply(this, arguments);
  };
}();
var createSubscription = /*#__PURE__*/function () {
  var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(companyId, domainId, email) {
    var _credential$token, credential, token, existingSub, response;
    return _regenerator["default"].wrap(function _callee3$(_context3) {
      while (1) switch (_context3.prev = _context3.next) {
        case 0:
          _context3.prev = 0;
          _context3.next = 3;
          return _credentials["default"].getCredentials(companyId, domainId);
        case 3:
          credential = _context3.sent;
          if (credential) {
            _context3.next = 6;
            break;
          }
          throw new Error("Invalid credentials!");
        case 6:
          token = credential === null || credential === void 0 ? void 0 : (_credential$token = credential.token) === null || _credential$token === void 0 ? void 0 : _credential$token.access_token;
          if (token) {
            _context3.next = 9;
            break;
          }
          throw new Error("Invalid credentials!");
        case 9:
          _context3.next = 11;
          return getExistingSubscription(email, token);
        case 11:
          existingSub = _context3.sent;
          if (!existingSub) {
            _context3.next = 16;
            break;
          }
          console.log("\uD83D\uDD39 Found existing subscription (".concat(existingSub.id, "), deleting it..."));
          _context3.next = 16;
          return deleteSubscription(existingSub.id, token);
        case 16:
          _context3.next = 18;
          return _axios["default"].post(GRAPH_API_URL, {
            changeType: "created",
            notificationUrl: "".concat(_config["default"].app.url, "/api/v1/report/webhook-report"),
            resource: "/users/".concat(email, "/mailFolders('Inbox')/messages"),
            expirationDateTime: new Date(Date.now() + MAX_SUBSCRIPTION_MINUTES * 60 * 1000).toISOString(),
            clientState: "".concat(companyId, "-").concat(domainId, "-").concat(email)
          }, {
            headers: {
              Authorization: "Bearer ".concat(token),
              "Content-Type": "application/json"
            }
          });
        case 18:
          response = _context3.sent;
          if ([200, 201].includes(response.status)) {
            _context3.next = 21;
            break;
          }
          throw new Error("Failed to create subscription: ".concat(response.statusText));
        case 21:
          console.log("New subscription created: ".concat(response.data.id));
          return _context3.abrupt("return", {
            success: true,
            message: "Subscription created successfully!",
            subscriptionId: response.data.id
          });
        case 25:
          _context3.prev = 25;
          _context3.t0 = _context3["catch"](0);
          console.error("Subscription creation error:", _context3.t0.message);
          return _context3.abrupt("return", {
            success: false,
            error: _context3.t0.message
          });
        case 29:
        case "end":
          return _context3.stop();
      }
    }, _callee3, null, [[0, 25]]);
  }));
  return function createSubscription(_x5, _x6, _x7) {
    return _ref3.apply(this, arguments);
  };
}();
exports.createSubscription = createSubscription;
var getMessageByInternetMessageId = /*#__PURE__*/function () {
  var _ref4 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(email, internetMessageId, accessToken) {
    var graphUrl, response, _error$response;
    return _regenerator["default"].wrap(function _callee4$(_context4) {
      while (1) switch (_context4.prev = _context4.next) {
        case 0:
          _context4.prev = 0;
          // Graph API endpoint to search for the email using internetMessageId
          graphUrl = "https://graph.microsoft.com/v1.0/users/".concat(email, "/messages?$filter=internetMessageId eq '").concat(internetMessageId, "'");
          _context4.next = 4;
          return _axios["default"].get(graphUrl, {
            headers: {
              Authorization: "Bearer ".concat(accessToken),
              Accept: "application/json"
            }
          });
        case 4:
          response = _context4.sent;
          if (!(response.data.value.length > 0)) {
            _context4.next = 10;
            break;
          }
          console.log("Email found:", response.data.value[0]);
          return _context4.abrupt("return", response.data.value[0]);
        case 10:
          console.log("No email found with the given InternetMessageId.");
          return _context4.abrupt("return", null);
        case 12:
          _context4.next = 18;
          break;
        case 14:
          _context4.prev = 14;
          _context4.t0 = _context4["catch"](0);
          console.error("Error fetching email:", ((_error$response = _context4.t0.response) === null || _error$response === void 0 ? void 0 : _error$response.data) || _context4.t0.message);
          throw _context4.t0;
        case 18:
        case "end":
          return _context4.stop();
      }
    }, _callee4, null, [[0, 14]]);
  }));
  return function getMessageByInternetMessageId(_x8, _x9, _x10) {
    return _ref4.apply(this, arguments);
  };
}();
exports.getMessageByInternetMessageId = getMessageByInternetMessageId;
var formatMailAttachments = function formatMailAttachments(mailAttachments) {
  console.log({
    mailAttachments: mailAttachments
  });
  return mailAttachments.map(function (attachment) {
    return {
      id: attachment.contentId || '',
      // Use contentId if available
      name: attachment.fileName || 'unknown',
      contentType: attachment.contentType || 'application/octet-stream',
      ContentBytes: attachment.content || null // Buffer content
    };
  });
};
exports.formatMailAttachments = formatMailAttachments;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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