"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syncDomainsFromTa = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _axios = _interopRequireDefault(require("axios"));
var _config = _interopRequireDefault(require("../config"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var syncDomainsFromTa = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(companyId) {
    var _response$data, _response$data$respon;
    var company, response, domains, domainIds, _iterator, _step, _loop;
    return _regenerator["default"].wrap(function _callee2$(_context3) {
      while (1) switch (_context3.prev = _context3.next) {
        case 0:
          _context3.next = 2;
          return db.Company.findOne({
            _id: companyId
          });
        case 2:
          company = _context3.sent;
          if (company) {
            _context3.next = 5;
            break;
          }
          throw new RequestError("Company not found", 404);
        case 5:
          _context3.next = 7;
          return _axios["default"].get("".concat(process.env.TAC_URL, "/api/sync-services/common/fetch-company-verified-domains/TPIR"), _objectSpread({
            headers: {
              Authorization: "Bearer ".concat(_config["default"].adminCentral.api_key)
            },
            params: {
              alias: company.alias,
              appName: "TPIR"
            }
          }, _config["default"].proxy.enableForTA && {
            httpsAgent: _config["default"].proxy.proxyAgent,
            httpAgent: _config["default"].proxy.proxyAgent
          }));
        case 7:
          response = _context3.sent;
          domains = (response === null || response === void 0 ? void 0 : (_response$data = response.data) === null || _response$data === void 0 ? void 0 : (_response$data$respon = _response$data.response) === null || _response$data$respon === void 0 ? void 0 : _response$data$respon.verifiedDomains) || [];
          domainIds = [];
          _iterator = _createForOfIteratorHelper(domains);
          _context3.prev = 11;
          _loop = /*#__PURE__*/_regenerator["default"].mark(function _loop() {
            var domain, _domainRecord, domainRecord, _domain$subDomains;
            return _regenerator["default"].wrap(function _loop$(_context2) {
              while (1) switch (_context2.prev = _context2.next) {
                case 0:
                  domain = _step.value;
                  if (!(domain.type !== null && domain.type !== "other")) {
                    _context2.next = 16;
                    break;
                  }
                  _context2.next = 4;
                  return db.Domain.findOne({
                    domainName: domain.domainName,
                    companyId: company._id
                  });
                case 4:
                  domainRecord = _context2.sent;
                  if (domainRecord) {
                    _context2.next = 12;
                    break;
                  }
                  _context2.next = 8;
                  return db.Domain.create({
                    domainName: domain.domainName,
                    txtRecord: domain.txtRecord,
                    isVerified: true,
                    companyId: companyId,
                    domainType: domain.type === "Google Workspace" ? "Gsuite" : "Outlook",
                    isCredential: false,
                    credential: null,
                    isSyncingUser: false,
                    isSyncingUserError: false,
                    isSyncingUserErrorFile: false,
                    domainTypeForOutlook: domain.type === "Google Workspace" ? null : domain.type === "Microsoft Outlook (Exchange)" ? 'EXCHANGE' : "OFFICE365"
                  });
                case 8:
                  domainRecord = _context2.sent;
                  if (!(domain !== null && domain !== void 0 && (_domain$subDomains = domain.subDomains) !== null && _domain$subDomains !== void 0 && _domain$subDomains.length)) {
                    _context2.next = 12;
                    break;
                  }
                  _context2.next = 12;
                  return Promise.all(domain.subDomains.map( /*#__PURE__*/function () {
                    var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(subDomain) {
                      var existingSubDomain;
                      return _regenerator["default"].wrap(function _callee$(_context) {
                        while (1) switch (_context.prev = _context.next) {
                          case 0:
                            _context.next = 2;
                            return db.SubDomainGroup.findOne({
                              groupName: subDomain,
                              domainId: domainRecord._id,
                              companyId: company._id
                            });
                          case 2:
                            existingSubDomain = _context.sent;
                            if (existingSubDomain) {
                              _context.next = 5;
                              break;
                            }
                            return _context.abrupt("return", db.SubDomainGroup.create({
                              groupName: subDomain,
                              domainId: domainRecord._id,
                              companyId: company._id
                            }));
                          case 5:
                          case "end":
                            return _context.stop();
                        }
                      }, _callee);
                    }));
                    return function (_x2) {
                      return _ref2.apply(this, arguments);
                    };
                  }()));
                case 12:
                  if (!(((_domainRecord = domainRecord) === null || _domainRecord === void 0 ? void 0 : _domainRecord.deletedAt) !== null)) {
                    _context2.next = 15;
                    break;
                  }
                  _context2.next = 15;
                  return db.Domain.updateOne({
                    _id: domainRecord._id
                  }, {
                    $set: {
                      deletedAt: null
                    }
                  });
                case 15:
                  domainIds.push(domainRecord._id);
                case 16:
                case "end":
                  return _context2.stop();
              }
            }, _loop);
          });
          _iterator.s();
        case 14:
          if ((_step = _iterator.n()).done) {
            _context3.next = 18;
            break;
          }
          return _context3.delegateYield(_loop(), "t0", 16);
        case 16:
          _context3.next = 14;
          break;
        case 18:
          _context3.next = 23;
          break;
        case 20:
          _context3.prev = 20;
          _context3.t1 = _context3["catch"](11);
          _iterator.e(_context3.t1);
        case 23:
          _context3.prev = 23;
          _iterator.f();
          return _context3.finish(23);
        case 26:
          _context3.next = 28;
          return db.Domain.updateMany({
            companyId: company._id,
            _id: {
              $nin: domainIds
            }
          }, {
            $set: {
              isSyncingUser: false,
              isSyncingUserError: false,
              isSyncingUserErrorFile: false,
              isCredential: false,
              credential: null,
              deletedAt: new Date()
            }
          });
        case 28:
          return _context3.abrupt("return", domainIds);
        case 29:
        case "end":
          return _context3.stop();
      }
    }, _callee2, null, [[11, 20, 23, 26]]);
  }));
  return function syncDomainsFromTa(_x) {
    return _ref.apply(this, arguments);
  };
}();
exports.syncDomainsFromTa = syncDomainsFromTa;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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