"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateGroupStatusAfterSync = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var updateGroupStatusAfterSync = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(groupId, companyId) {
    var allUsersGroup, currentGroup, groupsOfCompanyWhichHaveEmailAccess, groupsOfCompanyWhichHaveMessengerAccess, countOfUsersInAllUsersGroup, countOfUsersInCurrentGroup, emailLimit, messengerLimit;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return db.Group.findOne({
            companyId: companyId,
            groupName: "all-users-tpir",
            isDefaultGroup: true,
            deletedAt: null
          });
        case 3:
          allUsersGroup = _context.sent;
          _context.next = 6;
          return db.Group.findOne({
            companyId: companyId,
            isDefaultGroup: false,
            _id: groupId,
            deletedAt: null
          });
        case 6:
          currentGroup = _context.sent;
          _context.next = 9;
          return db.Group.find({
            companyId: companyId,
            deletedAt: null,
            emailAccess: true
          }).select('_id');
        case 9:
          groupsOfCompanyWhichHaveEmailAccess = _context.sent;
          _context.next = 12;
          return db.Group.find({
            companyId: companyId,
            deletedAt: null,
            messengerAccess: true
          });
        case 12:
          groupsOfCompanyWhichHaveMessengerAccess = _context.sent;
          _context.next = 15;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: [allUsersGroup._id]
            }
          });
        case 15:
          countOfUsersInAllUsersGroup = _context.sent;
          _context.next = 18;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: [currentGroup._id]
            }
          });
        case 18:
          countOfUsersInCurrentGroup = _context.sent;
          _context.next = 21;
          return db.MetaData.findOne({
            name: "userLimit",
            companyId: companyId,
            deletedAt: null
          });
        case 21:
          emailLimit = _context.sent.value;
          _context.next = 24;
          return db.MetaData.findOne({
            name: "userLimitMessenger",
            companyId: companyId,
            deletedAt: null
          });
        case 24:
          messengerLimit = _context.sent.value;
          if (!allUsersGroup.emailAccess) {
            _context.next = 31;
            break;
          }
          if (!(countOfUsersInAllUsersGroup > emailLimit)) {
            _context.next = 31;
            break;
          }
          _context.next = 29;
          return db.Group.updateOne({
            companyId: companyId,
            groupName: "all-users-tpir",
            isDefaultGroup: true,
            deletedAt: null
          }, {
            $set: {
              emailAccess: false
            }
          });
        case 29:
          _context.next = 31;
          return db.User.updateMany({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $nin: [groupsOfCompanyWhichHaveEmailAccess]
            }
          }, {
            $set: {
              isActive: false
            }
          });
        case 31:
          if (!allUsersGroup.messengerAccess) {
            _context.next = 37;
            break;
          }
          if (!(countOfUsersInAllUsersGroup > messengerLimit)) {
            _context.next = 37;
            break;
          }
          _context.next = 35;
          return db.Group.updateOne({
            companyId: companyId,
            groupName: "all-users-tpir",
            isDefaultGroup: true,
            deletedAt: null
          }, {
            $set: {
              messengerAccess: false
            }
          });
        case 35:
          _context.next = 37;
          return db.User.updateMany({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: [groupsOfCompanyWhichHaveMessengerAccess]
            }
          }, {
            $set: {
              isActiveMessenger: false
            }
          });
        case 37:
          if (!currentGroup.emailAccess) {
            _context.next = 43;
            break;
          }
          if (!(countOfUsersInCurrentGroup > emailLimit)) {
            _context.next = 43;
            break;
          }
          _context.next = 41;
          return db.Group.updateOne({
            companyId: companyId,
            _id: groupId,
            isDefaultGroup: false,
            deletedAt: null
          }, {
            $set: {
              emailAccess: false
            }
          });
        case 41:
          _context.next = 43;
          return db.User.updateMany({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: [groupsOfCompanyWhichHaveEmailAccess]
            }
          }, {
            $set: {
              isActive: false
            }
          });
        case 43:
          if (!currentGroup.messengerAccess) {
            _context.next = 49;
            break;
          }
          if (!(countOfUsersInCurrentGroup > messengerLimit)) {
            _context.next = 49;
            break;
          }
          _context.next = 47;
          return db.Group.updateOne({
            companyId: companyId,
            groupName: "all-users-tpir",
            isDefaultGroup: true,
            deletedAt: null
          }, {
            $set: {
              messengerAccess: false
            }
          });
        case 47:
          _context.next = 49;
          return db.User.updateMany({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: [groupsOfCompanyWhichHaveMessengerAccess]
            }
          }, {
            $set: {
              isActiveMessenger: false
            }
          });
        case 49:
          _context.next = 54;
          break;
        case 51:
          _context.prev = 51;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
        case 54:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 51]]);
  }));
  return function updateGroupStatusAfterSync(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();
exports.updateGroupStatusAfterSync = updateGroupStatusAfterSync;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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