"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateSyncingStatusOfGroups = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var updateSyncingStatusOfGroups = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(groupId, companyId) {
    var checkGroupWhichAreInSyncingStateOtherThanCurrentGroup, allUsersGroup, currentGroup, groupsOfCompanyWhichHaveEmailAccess, groupsOfCompanyWhichHaveMessengerAccess, countOfUsersInAllUsersGroup, emailLimit, messengerLimit, countOfUsersInCurrentGroup;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return db.Group.find({
            _id: {
              $ne: groupId
            },
            companyId: companyId,
            isSyncingUsers: true,
            isDefaultGroup: false
          });
        case 3:
          checkGroupWhichAreInSyncingStateOtherThanCurrentGroup = _context.sent;
          if (checkGroupWhichAreInSyncingStateOtherThanCurrentGroup.length) {
            _context.next = 7;
            break;
          }
          _context.next = 7;
          return db.Group.updateOne({
            groupName: "all-users-tpir",
            isDefaultGroup: true,
            companyId: companyId
          }, {
            $set: {
              isSyncingUsers: false
            }
          });
        case 7:
          _context.next = 9;
          return db.Group.updateOne({
            _id: groupId,
            companyId: companyId
          }, {
            $set: {
              isSyncingUsers: false
            }
          });
        case 9:
          _context.next = 11;
          return db.Group.findOne({
            companyId: companyId,
            groupName: "all-users-tpir",
            isDefaultGroup: true,
            deletedAt: null
          });
        case 11:
          allUsersGroup = _context.sent;
          _context.next = 14;
          return db.Group.findOne({
            companyId: companyId,
            isDefaultGroup: false,
            _id: groupId,
            deletedAt: null
          });
        case 14:
          currentGroup = _context.sent;
          _context.next = 17;
          return db.Group.find({
            companyId: companyId,
            deletedAt: null,
            emailAccess: true
          }).select('_id');
        case 17:
          groupsOfCompanyWhichHaveEmailAccess = _context.sent;
          _context.next = 20;
          return db.Group.find({
            companyId: companyId,
            deletedAt: null,
            messengerAccess: true
          });
        case 20:
          groupsOfCompanyWhichHaveMessengerAccess = _context.sent;
          _context.next = 23;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: [allUsersGroup._id]
            }
          });
        case 23:
          countOfUsersInAllUsersGroup = _context.sent;
          _context.t0 = parseInt;
          _context.next = 27;
          return db.MetaData.findOne({
            name: "userLimit",
            companyId: companyId,
            deletedAt: null
          });
        case 27:
          _context.t1 = _context.sent.value;
          emailLimit = (0, _context.t0)(_context.t1);
          _context.t2 = parseInt;
          _context.next = 32;
          return db.MetaData.findOne({
            name: "userLimitMessenger",
            companyId: companyId,
            deletedAt: null
          });
        case 32:
          _context.t3 = _context.sent.value;
          messengerLimit = (0, _context.t2)(_context.t3);
          if (!allUsersGroup.emailAccess) {
            _context.next = 40;
            break;
          }
          if (!(countOfUsersInAllUsersGroup > emailLimit)) {
            _context.next = 40;
            break;
          }
          _context.next = 38;
          return db.Group.updateOne({
            companyId: companyId,
            groupName: "all-users-tpir",
            isDefaultGroup: true,
            deletedAt: null
          }, {
            $set: {
              emailAccess: false
            }
          });
        case 38:
          _context.next = 40;
          return db.User.updateMany({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $nin: [groupsOfCompanyWhichHaveEmailAccess]
            }
          }, {
            $set: {
              isActive: false
            }
          });
        case 40:
          if (!allUsersGroup.messengerAccess) {
            _context.next = 46;
            break;
          }
          if (!(countOfUsersInAllUsersGroup > messengerLimit)) {
            _context.next = 46;
            break;
          }
          _context.next = 44;
          return db.Group.updateOne({
            companyId: companyId,
            groupName: "all-users-tpir",
            isDefaultGroup: true,
            deletedAt: null
          }, {
            $set: {
              messengerAccess: false
            }
          });
        case 44:
          _context.next = 46;
          return db.User.updateMany({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: [groupsOfCompanyWhichHaveMessengerAccess]
            }
          }, {
            $set: {
              isActiveMessenger: false
            }
          });
        case 46:
          if (!currentGroup) {
            _context.next = 62;
            break;
          }
          _context.next = 49;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: [currentGroup._id]
            }
          });
        case 49:
          countOfUsersInCurrentGroup = _context.sent;
          if (!currentGroup.emailAccess) {
            _context.next = 56;
            break;
          }
          if (!(countOfUsersInCurrentGroup > emailLimit)) {
            _context.next = 56;
            break;
          }
          _context.next = 54;
          return db.Group.updateOne({
            companyId: companyId,
            _id: groupId,
            isDefaultGroup: false,
            deletedAt: null
          }, {
            $set: {
              emailAccess: false
            }
          });
        case 54:
          _context.next = 56;
          return db.User.updateMany({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: [groupsOfCompanyWhichHaveEmailAccess]
            }
          }, {
            $set: {
              isActive: false
            }
          });
        case 56:
          if (!currentGroup.messengerAccess) {
            _context.next = 62;
            break;
          }
          if (!(countOfUsersInCurrentGroup > messengerLimit)) {
            _context.next = 62;
            break;
          }
          _context.next = 60;
          return db.Group.updateOne({
            companyId: companyId,
            _id: groupId,
            isDefaultGroup: false,
            deletedAt: null
          }, {
            $set: {
              messengerAccess: false
            }
          });
        case 60:
          _context.next = 62;
          return db.User.updateMany({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: [groupsOfCompanyWhichHaveMessengerAccess]
            }
          }, {
            $set: {
              isActiveMessenger: false
            }
          });
        case 62:
          _context.next = 67;
          break;
        case 64:
          _context.prev = 64;
          _context.t4 = _context["catch"](0);
          console.log(_context.t4);
        case 67:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 64]]);
  }));
  return function updateSyncingStatusOfGroups(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

// export let updateSyncingStatusOfGroups = async (groupId, companyId) => {
//     try {
//         const [
//             allUsersGroup,
//             currentGroup,
//             groupsOfCompanyWhichHaveEmailAccess,
//             groupsOfCompanyWhichHaveMessengerAccess,
//             countOfUsersInAllUsersGroup,
//             emailLimitMeta,
//             messengerLimitMeta
//         ] = await Promise.all([
//             db.Group.findOne({ companyId, groupName: "all-users-tpir", isDefaultGroup: true, deletedAt: null }),
//             db.Group.findOne({ companyId, isDefaultGroup: false, _id: groupId, deletedAt: null }),
//             db.Group.find({ companyId, deletedAt: null, emailAccess: true }).select('_id'),
//             db.Group.find({ companyId, deletedAt: null, messengerAccess: true }),
//             db.User.countDocuments({ companyId, deletedAt: null, groups: { $in: [allUsersGroup?._id] } }),
//             db.MetaData.findOne({ name: "userLimit", companyId, deletedAt: null }),
//             db.MetaData.findOne({ name: "userLimitMessenger", companyId, deletedAt: null })
//         ]);

//         if (!allUsersGroup || !currentGroup) throw new Error('Default groups not found.');

//         const emailLimit = parseInt(emailLimitMeta?.value || '0');
//         const messengerLimit = parseInt(messengerLimitMeta?.value || '0');

//         // Update syncing status for groups
//         const otherSyncingGroups = await db.Group.find({
//             companyId,
//             _id: { $ne: groupId },
//             isSyncingUsers: true,
//             isDefaultGroup: false
//         });

//         if (otherSyncingGroups.length === 0) {
//             await db.Group.updateOne({ companyId, groupName: "all-users-tpir", isDefaultGroup: true }, { $set: { isSyncingUsers: false } });
//         }

//         await db.Group.updateOne({ companyId, _id: groupId }, { $set: { isSyncingUsers: false } });

//         // Check and update user limits for email access
//         if (allUsersGroup.emailAccess && countOfUsersInAllUsersGroup > emailLimit) {
//             await Promise.all([
//                 db.Group.updateOne({ companyId, groupName: "all-users-tpir", isDefaultGroup: true }, { $set: { emailAccess: false } }),
//                 db.User.updateMany({ companyId, deletedAt: null, groups: { $nin: groupsOfCompanyWhichHaveEmailAccess } }, { $set: { isActive: false } })
//             ]);
//         }

//         // Check and update user limits for messenger access
//         if (allUsersGroup.messengerAccess && countOfUsersInAllUsersGroup > messengerLimit) {
//             await Promise.all([
//                 db.Group.updateOne({ companyId, groupName: "all-users-tpir", isDefaultGroup: true }, { $set: { messengerAccess: false } }),
//                 db.User.updateMany({ companyId, deletedAt: null, groups: { $in: groupsOfCompanyWhichHaveMessengerAccess } }, { $set: { isActiveMessenger: false } })
//             ]);
//         }

//         // Handle current group email and messenger limits
//         if (currentGroup) {
//             const countOfUsersInCurrentGroup = await db.User.countDocuments({ companyId, deletedAt: null, groups: { $in: [currentGroup._id] } });

//             if (currentGroup.emailAccess && countOfUsersInCurrentGroup > emailLimit) {
//                 await Promise.all([
//                     db.Group.updateOne({ companyId, _id: groupId, isDefaultGroup: false }, { $set: { emailAccess: false } }),
//                     db.User.updateMany({ companyId, deletedAt: null, groups: { $in: groupsOfCompanyWhichHaveEmailAccess } }, { $set: { isActive: false } })
//                 ]);
//             }

//             if (currentGroup.messengerAccess && countOfUsersInCurrentGroup > messengerLimit) {
//                 await Promise.all([
//                     db.Group.updateOne({ companyId, _id: groupId, isDefaultGroup: false }, { $set: { messengerAccess: false } }),
//                     db.User.updateMany({ companyId, deletedAt: null, groups: { $in: groupsOfCompanyWhichHaveMessengerAccess } }, { $set: { isActiveMessenger: false } })
//                 ]);
//             }
//         }

//     } catch (error) {
//         console.error('Error during syncing status update:', error.message || error);
//         throw error
//     }
// };
exports.updateSyncingStatusOfGroups = updateSyncingStatusOfGroups;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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