"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _axios = _interopRequireDefault(require("axios"));
var _credentials = _interopRequireDefault(require("./credentials"));
var _config = _interopRequireDefault(require("../config"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var getGroups = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(credential) {
    var axiosRequestConfig, apiRespo;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          axiosRequestConfig = _objectSpread({
            method: 'GET',
            url: 'https://graph.microsoft.com/v1.0/groups?$select=id,displayName',
            headers: {
              'content-type': 'application/json',
              authorization: "Bearer ".concat(credential.token.access_token)
            }
          }, _config["default"].proxy.enableForMicrosoftGraph && {
            httpsAgent: _config["default"].proxy.proxyAgent,
            httpAgent: _config["default"].proxy.proxyAgent
          });
          _context.next = 4;
          return _axios["default"].request(axiosRequestConfig);
        case 4:
          apiRespo = _context.sent;
          if (!(apiRespo && apiRespo.data)) {
            _context.next = 7;
            break;
          }
          return _context.abrupt("return", apiRespo.data.value);
        case 7:
          _context.next = 13;
          break;
        case 9:
          _context.prev = 9;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0.response.data);
          throw new RequestError("Error fetching groups");
        case 13:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 9]]);
  }));
  return function getGroups(_x) {
    return _ref.apply(this, arguments);
  };
}();
var _default = {
  get: function () {
    var _get = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(companyId, domainId) {
      var creds;
      return _regenerator["default"].wrap(function _callee2$(_context2) {
        while (1) switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return _credentials["default"].getCredentials(companyId, domainId);
          case 2:
            creds = _context2.sent;
            return _context2.abrupt("return", getGroups(creds));
          case 4:
          case "end":
            return _context2.stop();
        }
      }, _callee2);
    }));
    function get(_x2, _x3) {
      return _get.apply(this, arguments);
    }
    return get;
  }()
};
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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