"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processImageMessage = processImageMessage;
exports.sendWhatsappMessage = sendWhatsappMessage;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _axios = _interopRequireDefault(require("axios"));
var _config = _interopRequireDefault(require("../config"));
var _kue = require("../kue");
var _saveWhatsappImage = require("./saveWhatsappImage");
var _functions = require("../functions");
var _languageService = _interopRequireDefault(require("./languageService"));
var accessToken = _config["default"].whatsapp.accessToken;
function getImageImageUrl(_x) {
  return _getImageImageUrl.apply(this, arguments);
}
function _getImageImageUrl() {
  _getImageImageUrl = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(imageId) {
    var response;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          console.log("Inside getImageImageUrl with imageId --", imageId);
          _context.next = 4;
          return _axios["default"].get("https://graph.facebook.com/v16.0/".concat(imageId), {
            headers: {
              Authorization: "Bearer ".concat(accessToken)
            }
          });
        case 4:
          response = _context.sent;
          return _context.abrupt("return", response.data);
        case 8:
          _context.prev = 8;
          _context.t0 = _context["catch"](0);
          console.log("Error fetching image URL:", _context.t0.response.data);
          return _context.abrupt("return", false);
        case 12:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 8]]);
  }));
  return _getImageImageUrl.apply(this, arguments);
}
function sendWhatsappMessage(_x2, _x3, _x4, _x5) {
  return _sendWhatsappMessage.apply(this, arguments);
}
function _sendWhatsappMessage() {
  _sendWhatsappMessage = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(phone_number_id, message, to, messageId) {
    var response;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          _context2.next = 3;
          return _axios["default"].post("https://graph.facebook.com/v16.0/".concat(phone_number_id, "/messages"), {
            messaging_product: "whatsapp",
            to: to,
            text: {
              body: message
            },
            context: {
              message_id: messageId
            }
          }, {
            headers: {
              "Content-Type": "application/json",
              Authorization: "Bearer ".concat(accessToken)
            }
          });
        case 3:
          response = _context2.sent;
          if (!(response.status === 200)) {
            _context2.next = 7;
            break;
          }
          console.log("Successfully sent message: ".concat(message));
          return _context2.abrupt("return", true);
        case 7:
          return _context2.abrupt("return", false);
        case 10:
          _context2.prev = 10;
          _context2.t0 = _context2["catch"](0);
          console.log("Error sending WhatsApp message:", _context2.t0.response.data);
          return _context2.abrupt("return", false);
        case 14:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 10]]);
  }));
  return _sendWhatsappMessage.apply(this, arguments);
}
function processImageMessage(_x6, _x7, _x8, _x9, _x10, _x11) {
  return _processImageMessage.apply(this, arguments);
}
function _processImageMessage() {
  _processImageMessage = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(phone_number_id, from, message, name, companyId, userId) {
    var image_id, messageId, image, filename, filePath, dir, imageSave, preferedLanguage, ticketId, msg, sentMessage, reportedMessage;
    return _regenerator["default"].wrap(function _callee3$(_context3) {
      while (1) switch (_context3.prev = _context3.next) {
        case 0:
          image_id = message.image.id;
          messageId = message.id;
          _context3.next = 4;
          return getImageImageUrl(image_id);
        case 4:
          image = _context3.sent;
          if (image) {
            _context3.next = 8;
            break;
          }
          console.log("Error fetching image from WhatsApp!");
          return _context3.abrupt("return");
        case 8:
          console.log('Imageggggegegegeggegegeggegegegege', image);
          filename = "".concat(Date.now(), ".").concat(image.mime_type.split("/")[1]);
          filePath = _path["default"].join(appRoot, "Content", "whatsappImages", filename);
          console.log("File path:", filePath);

          // directory exists
          dir = _path["default"].dirname(filePath);
          if (!_fs["default"].existsSync(dir)) {
            _fs["default"].mkdirSync(dir, {
              recursive: true
            });
            console.log("Directory created:", dir);
          }
          _context3.next = 16;
          return (0, _saveWhatsappImage.saveImage)(image.url, filePath, accessToken);
        case 16:
          imageSave = _context3.sent;
          if (imageSave) {
            _context3.next = 20;
            break;
          }
          console.log("Error saving the image!");
          return _context3.abrupt("return");
        case 20:
          _context3.next = 22;
          return db.Company.findOne({
            _id: companyId
          }).select("whatsappLanguage");
        case 22:
          preferedLanguage = _context3.sent;
          console.log("Prefered language:---------", preferedLanguage);
          ticketId = "TPIR#".concat((0, _functions.randomString)(6));
          _context3.next = 27;
          return (0, _languageService["default"])("acknowledgment", preferedLanguage === null || preferedLanguage === void 0 ? void 0 : preferedLanguage.whatsappLanguage, {
            ticketId: ticketId
          });
        case 27:
          msg = _context3.sent;
          _context3.next = 30;
          return sendWhatsappMessage(phone_number_id, msg, from, messageId);
        case 30:
          sentMessage = _context3.sent;
          if (sentMessage) {
            _context3.next = 34;
            break;
          }
          console.log("Error sending prompt message!");
          return _context3.abrupt("return");
        case 34:
          _context3.next = 36;
          return db.whatsapp.create({
            from: name,
            phoneNumber: from,
            phoneNumberId: phone_number_id,
            messageId: message.id,
            type: 'image',
            imageId: image_id,
            imageUrl: image.url,
            fileName: filename,
            ticketId: ticketId,
            companyId: companyId,
            userId: userId
          });
        case 36:
          reportedMessage = _context3.sent;
          _kue.queue.create('process-whatsapp-image', {
            reportedMessage: reportedMessage,
            ticketId: ticketId,
            to: from,
            companyId: companyId,
            preferedLanguage: preferedLanguage === null || preferedLanguage === void 0 ? void 0 : preferedLanguage.whatsappLanguage
          }).removeOnComplete(true).priority('high').save();
          console.log("Image successfully downloaded and saved in directory!");
        case 39:
        case "end":
          return _context3.stop();
      }
    }, _callee3);
  }));
  return _processImageMessage.apply(this, arguments);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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