"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanupMirrorGroup = cleanupMirrorGroup;
exports.orphanSweepManualGroups = orphanSweepManualGroups;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
function cleanupMirrorGroup(_x) {
  return _cleanupMirrorGroup.apply(this, arguments);
}
function _cleanupMirrorGroup() {
  _cleanupMirrorGroup = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(_ref) {
    var companyId, groupId, syncTs, staleFilter;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          companyId = _ref.companyId, groupId = _ref.groupId, syncTs = _ref.syncTs;
          staleFilter = {
            companyId: companyId,
            groups: groupId,
            lastAdSeenAt: {
              $ne: syncTs
            }
          }; // Step 1: Remove users from the group if not seen in this sync
          _context.next = 4;
          return db.User.updateMany(staleFilter, {
            $pull: {
              groups: groupId
            }
          });
        case 4:
          _context.next = 6;
          return db.User.updateMany({
            companyId: companyId,
            isADSynced: true,
            deletedAt: null,
            groups: {
              $size: 0
            }
          }, {
            $set: {
              deletedAt: new Date()
            }
          });
        case 6:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return _cleanupMirrorGroup.apply(this, arguments);
}
function orphanSweepManualGroups(_x2) {
  return _orphanSweepManualGroups.apply(this, arguments);
}
function _orphanSweepManualGroups() {
  _orphanSweepManualGroups = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(_ref2) {
    var companyId, activeIds, manualGroupIds;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          companyId = _ref2.companyId;
          _context2.next = 3;
          return db.User.distinct('_id', {
            companyId: companyId,
            isADSynced: true,
            deletedAt: null
          });
        case 3:
          activeIds = _context2.sent;
          _context2.next = 6;
          return db.Group.distinct('_id', {
            companyId: companyId,
            isADSynced: false,
            deletedAt: null
          });
        case 6:
          manualGroupIds = _context2.sent;
          _context2.next = 9;
          return db.User.updateMany({
            companyId: companyId,
            _id: {
              $nin: activeIds
            }
          }, {
            $pull: {
              groups: {
                $in: manualGroupIds
              }
            }
          });
        case 9:
          console.log("Removed ".concat(activeIds.length, " users from ").concat(manualGroupIds.length, " manual groups in company ").concat(companyId));
        case 10:
        case "end":
          return _context2.stop();
      }
    }, _callee2);
  }));
  return _orphanSweepManualGroups.apply(this, arguments);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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