"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _nodeSchedule = _interopRequireDefault(require("node-schedule"));
var _processUser = _interopRequireDefault(require("../service/process-user"));
var _credentials = _interopRequireDefault(require("../service/credentials"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var dayMapping = {
  All: 0,
  Monday: 1,
  Tuesday: 2,
  Wednesday: 3,
  Thursday: 4,
  Friday: 5,
  Saturday: 6,
  Sunday: 0
};
var scheduler = {
  init: function () {
    var _init = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee() {
      var domains, _iterator, _step, d, s;
      return _regenerator["default"].wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return db.Domain.find({
              'isScheduledSyncing.isActive': true,
              deletedAt: null
            });
          case 2:
            domains = _context.sent;
            _iterator = _createForOfIteratorHelper(domains);
            _context.prev = 4;
            _iterator.s();
          case 6:
            if ((_step = _iterator.n()).done) {
              _context.next = 13;
              break;
            }
            d = _step.value;
            s = d.isScheduledSyncing;
            _context.next = 11;
            return scheduler.scheduleDomainAutoSyncSetting({
              domainId: d._id.toString(),
              companyId: d.companyId.toString(),
              days: s.daysOfWeek,
              hour: s.hour,
              minute: s.minute,
              timeZone: s.timeZone,
              syncType: s.syncType,
              groupIds: s.groupIds,
              isUserSyncMirrored: s.isUserSyncMirrored
            });
          case 11:
            _context.next = 6;
            break;
          case 13:
            _context.next = 18;
            break;
          case 15:
            _context.prev = 15;
            _context.t0 = _context["catch"](4);
            _iterator.e(_context.t0);
          case 18:
            _context.prev = 18;
            _iterator.f();
            return _context.finish(18);
          case 21:
            console.log("\u2714 Scheduler loaded ".concat(domains.length, " job(s)"));
          case 22:
          case "end":
            return _context.stop();
        }
      }, _callee, null, [[4, 15, 18, 21]]);
    }));
    function init() {
      return _init.apply(this, arguments);
    }
    return init;
  }(),
  // Cancel any existing job by ID
  cancelScheduledJob: function cancelScheduledJob(jobId) {
    return _nodeSchedule["default"].cancelJob(jobId.toString());
  },
  // Exactly your inline-scheduler logic, lifted into a reusable fn
  scheduleDomainAutoSyncSetting: function () {
    var _scheduleDomainAutoSyncSetting = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(_ref) {
      var domainId, companyId, _ref$days, days, hour, minute, timeZone, syncType, _ref$groupIds, groupIds, isUserSyncMirrored, rule;
      return _regenerator["default"].wrap(function _callee4$(_context4) {
        while (1) switch (_context4.prev = _context4.next) {
          case 0:
            domainId = _ref.domainId, companyId = _ref.companyId, _ref$days = _ref.days, days = _ref$days === void 0 ? [] : _ref$days, hour = _ref.hour, minute = _ref.minute, timeZone = _ref.timeZone, syncType = _ref.syncType, _ref$groupIds = _ref.groupIds, groupIds = _ref$groupIds === void 0 ? [] : _ref$groupIds, isUserSyncMirrored = _ref.isUserSyncMirrored;
            // 1) Tear down any previous job
            scheduler.cancelScheduledJob(domainId);

            // 2) Build the RecurrenceRule
            if (days.includes('All')) {
              days = days.filter(function (d) {
                return d !== 'All';
              });
            }
            rule = new _nodeSchedule["default"].RecurrenceRule();
            rule.hour = Number(hour);
            rule.minute = Number(minute);
            rule.tz = timeZone;
            if (days.length) {
              rule.dayOfWeek = days.map(function (d) {
                return dayMapping[d];
              });
            }

            // 3) Schedule it
            _nodeSchedule["default"].scheduleJob(domainId.toString(), rule, /*#__PURE__*/(0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3() {
              var syncTs, _domain$isScheduledSy, domain, autoSyncGroups, subDomainGroups, creds, allGroup, results;
              return _regenerator["default"].wrap(function _callee3$(_context3) {
                while (1) switch (_context3.prev = _context3.next) {
                  case 0:
                    syncTs = new Date();
                    _context3.prev = 1;
                    _context3.next = 4;
                    return db.Domain.findOne({
                      _id: domainId,
                      companyId: companyId,
                      deletedAt: null
                    });
                  case 4:
                    domain = _context3.sent;
                    if (domain) {
                      _context3.next = 7;
                      break;
                    }
                    throw new RequestError('Domain does not exist or wrong domain id passed!', 404);
                  case 7:
                    if (domain.isVerified) {
                      _context3.next = 9;
                      break;
                    }
                    throw new RequestError('Domain is not verified', 400);
                  case 9:
                    if (!(domain.isVerified && !domain.isCredential)) {
                      _context3.next = 11;
                      break;
                    }
                    throw new RequestError('Credentials are not uploaded', 400);
                  case 11:
                    if (!(domain.isVerified && domain.isCredential && domain.isSyncingUser)) {
                      _context3.next = 13;
                      break;
                    }
                    throw new RequestError("Syncing Already in Progress for ".concat(domain.domainName, ". Kindly wait until syncing is completed!"), 400);
                  case 13:
                    if ((_domain$isScheduledSy = domain.isScheduledSyncing) !== null && _domain$isScheduledSy !== void 0 && _domain$isScheduledSy.isActive) {
                      _context3.next = 15;
                      break;
                    }
                    throw new RequestError('Scheduled Sync is not active for this domain.', 400);
                  case 15:
                    // ─── B) Prep groups & creds ──────────────────────────────
                    autoSyncGroups = domain.isScheduledSyncing.groupIds || [];
                    console.log("domain.isScheduledSyncing------------------------", domain.isScheduledSyncing);
                    _context3.next = 19;
                    return db.SubDomainGroup.find({
                      domainId: domain._id,
                      companyId: companyId
                    }, {
                      _id: 1,
                      groupName: 1
                    });
                  case 19:
                    subDomainGroups = _context3.sent;
                    subDomainGroups = subDomainGroups.map(function (g) {
                      return g.groupName;
                    });
                    _context3.next = 23;
                    return _credentials["default"].getCredentials(companyId, domainId);
                  case 23:
                    creds = _context3.sent;
                    _context3.next = 26;
                    return db.Group.findOne({
                      companyId: companyId,
                      isDefaultGroup: true,
                      deletedAt: null
                    });
                  case 26:
                    allGroup = _context3.sent;
                    if (allGroup) {
                      _context3.next = 29;
                      break;
                    }
                    throw new Error('Default all-users group not found');
                  case 29:
                    if (!(autoSyncGroups.length > 0 && syncType === 'specificGroups')) {
                      _context3.next = 37;
                      break;
                    }
                    console.log({
                      autoSyncGroups: autoSyncGroups
                    });
                    _context3.next = 33;
                    return Promise.allSettled(autoSyncGroups.map( /*#__PURE__*/function () {
                      var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(adGroupId) {
                        var isExchange, groupName, grp;
                        return _regenerator["default"].wrap(function _callee2$(_context2) {
                          while (1) switch (_context2.prev = _context2.next) {
                            case 0:
                              // per-AD group
                              isExchange = domain.domainTypeForOutlook === 'EXCHANGE';
                              groupName = isExchange ? "".concat(adGroupId.name, "-Exchange") : adGroupId.name;
                              console.log('groupName:-----------addd', groupName);
                              _context2.next = 5;
                              return db.Group.findOne({
                                groupName: groupName,
                                groupId: adGroupId._id,
                                domainId: domainId,
                                companyId: companyId,
                                deletedAt: null
                              });
                            case 5:
                              grp = _context2.sent;
                              if (grp) {
                                _context2.next = 10;
                                break;
                              }
                              _context2.next = 9;
                              return db.Group.create({
                                companyId: companyId,
                                groupName: groupName,
                                type: 'Admin',
                                groupId: adGroupId._id,
                                domainId: domainId,
                                isADSynced: true,
                                isSyncingUsers: false
                              });
                            case 9:
                              grp = _context2.sent;
                            case 10:
                              console.log('isMirror:', domain.isScheduledSyncing.isUserSyncMirrored);
                              _context2.next = 13;
                              return _processUser["default"].process(companyId, domainId, domain.domainName, subDomainGroups, domain.domainType, false, domain.domainTypeForOutlook === 'EXCHANGE', grp, creds, isUserSyncMirrored, null, syncTs);
                            case 13:
                              return _context2.abrupt("return", {
                                groupId: grp._id,
                                status: 'ok'
                              });
                            case 14:
                            case "end":
                              return _context2.stop();
                          }
                        }, _callee2);
                      }));
                      return function (_x2) {
                        return _ref3.apply(this, arguments);
                      };
                    }()));
                  case 33:
                    results = _context3.sent;
                    console.log('Sync results:', results);
                    _context3.next = 42;
                    break;
                  case 37:
                    // All‐users branch
                    console.log('isMirror:', domain.isScheduledSyncing.isUserSyncMirrored);
                    _context3.next = 40;
                    return _processUser["default"].process(companyId, domainId, domain.domainName, subDomainGroups, domain.domainType, false, domain.domainTypeForOutlook === 'EXCHANGE', allGroup, creds, isUserSyncMirrored, allGroup._id, syncTs);
                  case 40:
                    _context3.next = 42;
                    return db.Domain.updateOne({
                      _id: domainId
                    }, {
                      lastAllUsersSyncAt: syncTs
                    });
                  case 42:
                    if (!(autoSyncGroups.length > 0 && syncType === 'specificGroups' && isUserSyncMirrored && !domain.lastAllUsersSyncAt)) {
                      _context3.next = 47;
                      break;
                    }
                    _context3.next = 45;
                    return db.User.updateMany({
                      companyId: companyId,
                      domainId: domainId,
                      isADSynced: true,
                      groups: allGroup._id,
                      lastAdSeenAt: {
                        $ne: syncTs
                      }
                    }, {
                      $pull: {
                        groups: allGroup._id
                      }
                    });
                  case 45:
                    _context3.next = 47;
                    return db.User.updateMany({
                      companyId: companyId,
                      isADSynced: true,
                      deletedAt: null,
                      groups: {
                        $size: 0
                      }
                    }, {
                      $set: {
                        deletedAt: new Date()
                      }
                    });
                  case 47:
                    _context3.next = 52;
                    break;
                  case 49:
                    _context3.prev = 49;
                    _context3.t0 = _context3["catch"](1);
                    console.error('Scheduled sync error:', _context3.t0);
                  case 52:
                  case "end":
                    return _context3.stop();
                }
              }, _callee3, null, [[1, 49]]);
            })));
            console.log("\uD83D\uDD14 Scheduled domain ".concat(domainId, " @ ").concat(hour, ":").concat(minute, " (").concat(timeZone, ")"));
          case 10:
          case "end":
            return _context4.stop();
        }
      }, _callee4);
    }));
    function scheduleDomainAutoSyncSetting(_x) {
      return _scheduleDomainAutoSyncSetting.apply(this, arguments);
    }
    return scheduleDomainAutoSyncSetting;
  }()
};
var _default = scheduler;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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