"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var path = require('path');
var _require = require('googleapis'),
  gmail_v1 = _require.gmail_v1,
  google = _require.google;
function parsedHeader(result) {
  var emailData = result.data.payload.headers;
  var bodyData = '';
  if (result.data.payload.body.data !== undefined) {
    bodyData = result.data.payload.body.data;
  } else if (result.data.payload.parts.length) {
    bodyData = result.data.payload.parts[1].body.data;
  }
  var decodedBodyData = '';
  if (bodyData) {
    var bufferObj = Buffer.from(bodyData, "base64");
    decodedBodyData = bufferObj.toString("utf8");
  } else {
    bodyData = result.data.payload.parts[0].parts[1].body.data;
    if (bodyData) {
      var _bufferObj = Buffer.from(bodyData, "base64");
      decodedBodyData = _bufferObj.toString("utf8");
    }
  }
  var searchData = {};
  var _iterator = _createForOfIteratorHelper(emailData),
    _step;
  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var resObj = _step.value;
      if (resObj.name === 'Delivered-To') {
        searchData['to'] = resObj.value;
      }
      if (resObj.name === 'To') {
        var toMail = resObj.value;
        var tomail = toMail.match(/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/);
        searchData['To'] = (0, _toConsumableArray2["default"])(new Set(tomail));
      }
      if (!searchData['to'] && resObj.name === 'To') {
        var to = resObj.value;
        to = to.match(/([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4})/gi)[0];
        searchData['to'] = to;
      }
      if (resObj.name === 'From') {
        var from = resObj.value;
        from = from.match(/([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4})/gi)[0];
        searchData['from'] = from;
      }
      if (resObj.name === 'Subject') {
        searchData['subject'] = resObj.value;
      }
      if (resObj.name === 'Date') {
        searchData['date'] = resObj.value;
      }
      if (resObj.name === 'Cc' || resObj.name === 'CC') {
        var ccMail = resObj.value;
        var ccmail = ccMail.match(/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/);
        searchData['cc'] = (0, _toConsumableArray2["default"])(new Set(ccmail));
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  searchData['body'] = decodedBodyData;
  return searchData;
}
function processAdvancedSearchGsuite(data) {
  return new Promise( /*#__PURE__*/function () {
    var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(resolve) {
      var _result$data, to, fileName, filter, credentialFilePath, authClient, gmail, result, i, message, parsed;
      return _regenerator["default"].wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _context.prev = 0;
            to = data.to, fileName = data.fileName, filter = data.filter;
            credentialFilePath = path.join(__dirname, '..', 'Content', 'Credentials', fileName);
            authClient = new google.auth.JWT({
              keyFile: credentialFilePath,
              scopes: ['https://mail.google.com/', 'https://www.googleapis.com/auth/admin.directory.user'],
              subject: to
            });
            _context.next = 6;
            return authClient.authorize();
          case 6:
            gmail = new gmail_v1.Gmail({
              auth: authClient
            });
            _context.next = 9;
            return gmail.users.messages.list({
              q: filter,
              userId: to,
              auth: authClient,
              includeSpamTrash: true
            });
          case 9:
            result = _context.sent;
            console.log(result.data);
            if (!(result.status == 200 && result !== null && result !== void 0 && (_result$data = result.data) !== null && _result$data !== void 0 && _result$data.messages)) {
              _context.next = 30;
              break;
            }
            data['isMailFound'] = [];
            i = 0;
          case 14:
            if (!(i < result.data.messages.length)) {
              _context.next = 28;
              break;
            }
            console.log(result.data.messages[i]);
            _context.next = 18;
            return gmail.users.messages.get({
              userId: to,
              auth: authClient,
              id: result.data.messages[i].id
            });
          case 18:
            message = _context.sent;
            _context.next = 21;
            return parsedHeader(message);
          case 21:
            parsed = _context.sent;
            parsed['messageId'] = result.data.messages[i].id;
            parsed['threadId'] = result.data.messages[i].threadId;
            data['isMailFound'].push(parsed);
          case 25:
            i++;
            _context.next = 14;
            break;
          case 28:
            _context.next = 31;
            break;
          case 30:
            data['isMailFound'] = [];
          case 31:
            resolve(data);
            _context.next = 39;
            break;
          case 34:
            _context.prev = 34;
            _context.t0 = _context["catch"](0);
            console.log(_context.t0);
            data['isMailFound'] = [];
            resolve(data);
          case 39:
          case "end":
            return _context.stop();
        }
      }, _callee, null, [[0, 34]]);
    }));
    return function (_x) {
      return _ref.apply(this, arguments);
    };
  }());
}
module.exports = processAdvancedSearchGsuite;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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