"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var dnsbl = require('dnsbl');
var urls = ["all.s5h.net", "b.barracudacentral.org", "bl.spamcop.net", "blacklist.woody.ch", "bogons.cymru.com", "cbl.abuseat.org", "combined.abuse.ch", "db.wpbl.info", "dnsbl-1.uceprotect.net", "dnsbl-2.uceprotect.net", "dnsbl-3.uceprotect.net", "dnsbl.dronebl.org", "dnsbl.sorbs.net", "drone.abuse.ch", "duinv.aupads.org", "dul.dnsbl.sorbs.net", "dyna.spamrats.com", "http.dnsbl.sorbs.net", "ips.backscatterer.org", "ix.dnsbl.manitu.net", "korea.services.net", "misc.dnsbl.sorbs.net", "noptr.spamrats.com", "orvedb.aupads.org", "pbl.spamhaus.org", "proxy.bl.gweep.ca", "psbl.surriel.com", "relays.bl.gweep.ca", "relays.nether.net", "sbl.spamhaus.org", "singular.ttk.pte.hu", "smtp.dnsbl.sorbs.net", "socks.dnsbl.sorbs.net", "spam.abuse.ch", "spam.dnsbl.anonmails.de", "spam.dnsbl.sorbs.net", "spam.spamrats.com", "spambot.bls.digibase.ca", "spamrbl.imp.ch", "spamsources.fabel.dk", "ubl.lashback.com", "ubl.unsubscore.com", "virus.rbl.jp", "web.dnsbl.sorbs.net", "wormrbl.imp.ch", "xbl.spamhaus.org", "z.mailspike.net", "zen.spamhaus.org", "zombie.dnsbl.sorbs.net"];
function processDNSBL(data) {
  return new Promise( /*#__PURE__*/function () {
    var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(resolve) {
      return _regenerator["default"].wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            try {
              dnsbl.batch(data.senderIp, urls).then(function (result) {
                data['dnsbl'] = result;
                resolve(data);
              });
            } catch (err) {
              console.log(err);
              data['dnsbl'] = [];
              resolve(data);
            }
          case 1:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function (_x) {
      return _ref.apply(this, arguments);
    };
  }());
}
module.exports = processDNSBL;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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