"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var path = require('path');
var _require = require('googleapis'),
  gmail_v1 = _require.gmail_v1,
  google = _require.google;
function processWhoElseGsuite(data) {
  return new Promise( /*#__PURE__*/function () {
    var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(resolve, reject) {
      var _result$data, _result$data2, email, from, fileName, subject, internetMessageId, credentialFilePath, authClient, gmail, result, checkLabel, labels, emailHeaders, subjectHeader;
      return _regenerator["default"].wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _context.prev = 0;
            console.log("SUBJECT----------------------------------->", data.subject);
            // console.log('processing who else gsuite', data.index, data.email, data.from, data.subject);
            email = data.email, from = data.from, fileName = data.fileName, subject = data.subject, internetMessageId = data.internetMessageId;
            credentialFilePath = path.join(__dirname, '..', 'Content', 'Credentials', fileName);
            authClient = new google.auth.JWT({
              keyFile: credentialFilePath,
              scopes: ['https://mail.google.com/', 'https://www.googleapis.com/auth/admin.directory.user'],
              subject: email
            });
            _context.next = 7;
            return authClient.authorize();
          case 7:
            gmail = new gmail_v1.Gmail({
              auth: authClient
            });
            _context.next = 10;
            return gmail.users.messages.list({
              q: "subject=".concat(subject),
              userId: email,
              auth: authClient,
              format: 'full',
              includeSpamTrash: true
            });
          case 10:
            result = _context.sent;
            if (result.status == 200 && result !== null && result !== void 0 && (_result$data = result.data) !== null && _result$data !== void 0 && _result$data.messages) {
              console.log("------------------>", result.data);
            }
            if (!(result.status == 200 && result !== null && result !== void 0 && (_result$data2 = result.data) !== null && _result$data2 !== void 0 && _result$data2.messages)) {
              _context.next = 25;
              break;
            }
            _context.next = 15;
            return gmail.users.messages.get({
              id: result.data.messages[0].id,
              userId: email,
              auth: authClient,
              includeSpamTrash: true
            });
          case 15:
            checkLabel = _context.sent;
            labels = checkLabel.data.labelIds;
            console.log(labels);
            console.log(labels.includes('INBOX'));
            emailHeaders = checkLabel.data.payload.headers;
            subjectHeader = emailHeaders.find(function (header) {
              return header.name.toLowerCase() === 'subject';
            });
            subjectHeader = subjectHeader ? subjectHeader.value : '';
            data['isMailFound'] = {
              'messageId': result.data.messages[0].id,
              'threadId': result.data.messages[0].threadId,
              'isTrashed': labels.includes('TRASH') ? true : false,
              'subject': subjectHeader
            };
            _context.next = 26;
            break;
          case 25:
            data['isMailFound'] = null;
          case 26:
            console.log('done similiar search gsuite', data.index);
            resolve(data);
            _context.next = 34;
            break;
          case 30:
            _context.prev = 30;
            _context.t0 = _context["catch"](0);
            data['isMailFound'] = null;
            reject(_context.t0);
          case 34:
          case "end":
            return _context.stop();
        }
      }, _callee, null, [[0, 30]]);
    }));
    return function (_x, _x2) {
      return _ref.apply(this, arguments);
    };
  }());
}
module.exports = processWhoElseGsuite;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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