"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _axios = _interopRequireDefault(require("axios"));
var _anArrayOfEnglishWords = _interopRequireDefault(require("an-array-of-english-words"));
var _config2 = _interopRequireDefault(require("../config"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var cleanDictionaryAndSpecialChars = function cleanDictionaryAndSpecialChars(text) {
  try {
    var dictionary = new Set(_anArrayOfEnglishWords["default"]);
    var wordArray = text.split(/\s+/);
    var filteredWords = wordArray.filter(function (word) {
      var cleanWord = word.replace(/[.,/#!$%^&?*;:{}=\-_`~()]/g, "").toLowerCase();
      return dictionary.has(cleanWord);
    });
    var filteredDictionaryWords = filteredWords.join(' ');
    filteredDictionaryWords.replace(/\\r\\n|\\n|\\r|\\t/g, ' ');
    var finalText = filteredDictionaryWords.replace(/\s+/g, ' ').trim();
    return finalText;
  } catch (error) {
    console.log("Error from cleaning dictionary and special chars", error);
  }
};
var outlookBatchProcess = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(requests, token) {
    var data, _config, response, result;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          data = {
            requests: requests
          };
          _config = _objectSpread({
            method: 'POST',
            url: 'https://graph.microsoft.com/v1.0/$batch/',
            headers: {
              'content-type': 'application/json',
              authorization: "Bearer ".concat(token)
            },
            data: data
          }, _config.proxy.enableForMicrosoftGraph && {
            httpsAgent: _config.proxy.proxyAgent,
            httpAgent: _config.proxy.proxyAgent
          });
          _context.next = 5;
          return _axios["default"].request(_config);
        case 5:
          response = _context.sent;
          result = response.data.responses;
          return _context.abrupt("return", result);
        case 10:
          _context.prev = 10;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          return _context.abrupt("return", []);
        case 14:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 10]]);
  }));
  return function outlookBatchProcess(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();
function processSimiliarSearchOutlook(data, isLast) {
  return new Promise( /*#__PURE__*/function () {
    var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(resolve, reject) {
      var trashRequests, messageMap, sanitizedSubject, i, _data$i, email, userId, internetMessageId, mailAction, bodyText, checkTrashApi, checkTrashReq, trashResponses, mailResults, inboxRequests, _i, isMailFound, messageData, inboxResponses, _i2, _isMailFound, _mailResults$push, _messageData;
      return _regenerator["default"].wrap(function _callee2$(_context2) {
        while (1) switch (_context2.prev = _context2.next) {
          case 0:
            _context2.prev = 0;
            trashRequests = [];
            messageMap = {};
            sanitizedSubject = data[0].subject;
            console.log(sanitizedSubject);
            for (i = 0; i < data.length; i++) {
              _data$i = data[i], email = _data$i.email, userId = _data$i.userId, internetMessageId = _data$i.internetMessageId, mailAction = _data$i.mailAction, bodyText = _data$i.bodyText;
              checkTrashApi = "/users/".concat(email, "/mailFolders/deleteditems/messages?$top=1&$filter=contains(subject,'").concat(sanitizedSubject, "')");
              checkTrashReq = {
                id: email,
                method: 'GET',
                url: checkTrashApi
              };
              trashRequests.push(checkTrashReq);
              messageMap[email] = data[i];
            }
            trashResponses = [];
            _context2.next = 9;
            return outlookBatchProcess(trashRequests, data[0].token);
          case 9:
            trashResponses = _context2.sent;
            console.log(trashRequests[0]);
            mailResults = [];
            inboxRequests = [];
            for (_i = 0; _i < trashResponses.length; _i++) {
              if (trashResponses[_i].status == 200) {
                isMailFound = trashResponses[_i].body.value[0];
                if (isMailFound && isMailFound.id) {
                  messageData = messageMap[trashResponses[_i].id];
                  mailResults.push({
                    from: messageData.from,
                    subject: isMailFound.subject,
                    reportedMailId: messageData.reportedMailId,
                    companyId: messageData.companyId,
                    domainId: messageData.domainId,
                    isLast: messageData.isLast,
                    internetMessageId: messageData.internetMessageId,
                    messageId: isMailFound.id,
                    name: messageData.name,
                    emailUserId: messageData.emailUserId ? messageData.emailUserId : null,
                    email: messageData.email,
                    foundInTrash: true,
                    foundInInbox: false,
                    mailAction: messageData.mailAction
                  });
                }
              }
              if (trashResponses[_i].status == 404 || trashResponses[_i].status == 200 && trashResponses[_i].body.value && !trashResponses[_i].body.value.length && !trashResponses[_i].body.value[0]) {
                inboxRequests.push({
                  id: trashResponses[_i].id,
                  method: "GET",
                  url: "/users/".concat(trashResponses[_i].id, "/messages?$top=1&$filter=contains(subject,'").concat(sanitizedSubject, "')")
                });
              }
            }
            inboxResponses = [];
            if (!inboxRequests.length) {
              _context2.next = 20;
              break;
            }
            _context2.next = 18;
            return outlookBatchProcess(inboxRequests, data[0].token);
          case 18:
            inboxResponses = _context2.sent;
            console.log(inboxResponses[0]);
          case 20:
            for (_i2 = 0; _i2 < inboxResponses.length; _i2++) {
              if (inboxResponses[_i2].status == 200) {
                _isMailFound = inboxResponses[_i2].body.value[0];
                if (_isMailFound && _isMailFound.id) {
                  _messageData = messageMap[inboxResponses[_i2].id];
                  mailResults.push((_mailResults$push = {
                    from: _messageData.from,
                    subject: _isMailFound.subject,
                    reportedMailId: _messageData.reportedMailId,
                    companyId: _messageData.companyId,
                    domainId: _messageData.domainId,
                    email: _messageData.email,
                    isLast: _messageData.isLast,
                    internetMessageId: _messageData.internetMessageId,
                    messageId: _isMailFound.id,
                    name: _messageData.name,
                    emailUserId: _messageData.emailUserId ? _messageData.emailUserId : null
                  }, (0, _defineProperty2["default"])(_mailResults$push, "email", _messageData.email), (0, _defineProperty2["default"])(_mailResults$push, "foundInInbox", true), (0, _defineProperty2["default"])(_mailResults$push, "foundInTrash", false), (0, _defineProperty2["default"])(_mailResults$push, "mailAction", _messageData.mailAction), (0, _defineProperty2["default"])(_mailResults$push, "folderId", _isMailFound.parentFolderId), _mailResults$push));
                }
              }
            }
            resolve(mailResults);
            _context2.next = 28;
            break;
          case 24:
            _context2.prev = 24;
            _context2.t0 = _context2["catch"](0);
            console.log('errrororor', _context2.t0);
            reject(_context2.t0);
          case 28:
          case "end":
            return _context2.stop();
        }
      }, _callee2, null, [[0, 24]]);
    }));
    return function (_x3, _x4) {
      return _ref2.apply(this, arguments);
    };
  }());
}
var _default = processSimiliarSearchOutlook;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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