"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  addExpectContinueMiddleware: () => addExpectContinueMiddleware,
  addExpectContinueMiddlewareOptions: () => addExpectContinueMiddlewareOptions,
  getAddExpectContinuePlugin: () => getAddExpectContinuePlugin
});
module.exports = __toCommonJS(src_exports);
var import_protocol_http = require("@smithy/protocol-http");
function addExpectContinueMiddleware(options) {
  return (next) => async (args) => {
    var _a, _b;
    const { request } = args;
    if (import_protocol_http.HttpRequest.isInstance(request) && request.body && options.runtime === "node") {
      if (((_b = (_a = options.requestHandler) == null ? void 0 : _a.constructor) == null ? void 0 : _b.name) !== "FetchHttpHandler") {
        request.headers = {
          ...request.headers,
          Expect: "100-continue"
        };
      }
    }
    return next({
      ...args,
      request
    });
  };
}
__name(addExpectContinueMiddleware, "addExpectContinueMiddleware");
var addExpectContinueMiddlewareOptions = {
  step: "build",
  tags: ["SET_EXPECT_HEADER", "EXPECT_HEADER"],
  name: "addExpectContinueMiddleware",
  override: true
};
var getAddExpectContinuePlugin = /* @__PURE__ */ __name((options) => ({
  applyToStack: (clientStack) => {
    clientStack.add(addExpectContinueMiddleware(options), addExpectContinueMiddlewareOptions);
  }
}), "getAddExpectContinuePlugin");
// Annotate the CommonJS export names for ESM import in node:

0 && (module.exports = {
  addExpectContinueMiddleware,
  addExpectContinueMiddlewareOptions,
  getAddExpectContinuePlugin
});

