<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# isnan

[![NPM version][npm-image]][npm-url] [![Build Status][test-image]][test-url] [![Coverage Status][coverage-image]][coverage-url] <!-- [![dependencies][dependencies-image]][dependencies-url] -->

> Test if a double-precision floating-point numeric value is NaN.

<section class="installation">

## Installation

```bash
npm install @stdlib/math-base-assert-is-nan
```

</section>

<section class="usage">

## Usage

```javascript
var isnan = require( '@stdlib/math-base-assert-is-nan' );
```

#### isnan( x )

Tests if a double-precision floating-point `numeric` value is `NaN`.

```javascript
var bool = isnan( NaN );
// returns true
```

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- eslint no-undef: "error" -->

```javascript
var isnan = require( '@stdlib/math-base-assert-is-nan' );

var bool = isnan( NaN );
// returns true

bool = isnan( 5.0 );
// returns false
```

</section>

<!-- /.examples -->

<!-- Section for related `stdlib` packages. Do not manually edit this section, as it is automatically populated. -->

<section class="related">

* * *

## See Also

-   <span class="package-name">[`@stdlib/math/base/assert/is-nanf`][@stdlib/math/base/assert/is-nanf]</span><span class="delimiter">: </span><span class="description">test if a single-precision floating-point numeric value is NaN.</span>

</section>

<!-- /.related -->

<!-- Section for all links. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->


<section class="main-repo" >

* * *

## Notice

This package is part of [stdlib][stdlib], a standard library for JavaScript and Node.js, with an emphasis on numerical and scientific computing. The library provides a collection of robust, high performance libraries for mathematics, statistics, streams, utilities, and more.

For more information on the project, filing bug reports and feature requests, and guidance on how to develop [stdlib][stdlib], see the main project [repository][stdlib].

#### Community

[![Chat][chat-image]][chat-url]

---

## License

See [LICENSE][stdlib-license].


## Copyright

Copyright &copy; 2016-2022. The Stdlib [Authors][stdlib-authors].

</section>

<!-- /.stdlib -->

<!-- Section for all links. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="links">

[npm-image]: http://img.shields.io/npm/v/@stdlib/math-base-assert-is-nan.svg
[npm-url]: https://npmjs.org/package/@stdlib/math-base-assert-is-nan

[test-image]: https://github.com/stdlib-js/math-base-assert-is-nan/actions/workflows/test.yml/badge.svg
[test-url]: https://github.com/stdlib-js/math-base-assert-is-nan/actions/workflows/test.yml

[coverage-image]: https://img.shields.io/codecov/c/github/stdlib-js/math-base-assert-is-nan/main.svg
[coverage-url]: https://codecov.io/github/stdlib-js/math-base-assert-is-nan?branch=main

<!--

[dependencies-image]: https://img.shields.io/david/stdlib-js/math-base-assert-is-nan.svg
[dependencies-url]: https://david-dm.org/stdlib-js/math-base-assert-is-nan/main

-->

[umd]: https://github.com/umdjs/umd
[es-module]: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Modules

[deno-url]: https://github.com/stdlib-js/math-base-assert-is-nan/tree/deno
[umd-url]: https://github.com/stdlib-js/math-base-assert-is-nan/tree/umd
[esm-url]: https://github.com/stdlib-js/math-base-assert-is-nan/tree/esm

[chat-image]: https://img.shields.io/gitter/room/stdlib-js/stdlib.svg
[chat-url]: https://gitter.im/stdlib-js/stdlib/

[stdlib]: https://github.com/stdlib-js/stdlib

[stdlib-authors]: https://github.com/stdlib-js/stdlib/graphs/contributors

[stdlib-license]: https://raw.githubusercontent.com/stdlib-js/math-base-assert-is-nan/main/LICENSE

<!-- <related-links> -->

[@stdlib/math/base/assert/is-nanf]: https://www.npmjs.com/package/@stdlib/math-base-assert-is-nanf

<!-- </related-links> -->

</section>

<!-- /.links -->
