<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# uppercase

[![NPM version][npm-image]][npm-url] [![Build Status][test-image]][test-url] [![Coverage Status][coverage-image]][coverage-url] <!-- [![dependencies][dependencies-image]][dependencies-url] -->

> Convert a string to uppercase.

<section class="intro">

</section>

<!-- /.intro -->

<section class="installation">

## Installation

```bash
npm install @stdlib/string-uppercase
```

</section>

<section class="usage">

## Usage

```javascript
var uppercase = require( '@stdlib/string-uppercase' );
```

#### uppercase( str )

Converts a `string` to uppercase.

```javascript
var str = uppercase( 'bEEp' );
// returns 'BEEP'
```

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- eslint no-undef: "error" -->

```javascript
var uppercase = require( '@stdlib/string-uppercase' );

var str;

str = uppercase( 'Beep' );
// returns 'BEEP'

str = uppercase( 'BeEp' );
// returns 'BEEP'

str = uppercase( 'Beep BOOP' );
// returns 'BEEP BOOP'

str = uppercase( '$**_beep_BoOp_**$' );
// returns '$**_BEEP_BOOP_**$'

str = uppercase( '' );
// returns ''
```

</section>

<!-- /.examples -->

* * *

<section class="cli">

## CLI

<section class="installation">

## Installation

To use the module as a general utility, install the module globally

```bash
npm install -g @stdlib/string-uppercase
```

</section>

<!-- CLI usage documentation. -->

<section class="usage">

### Usage

```text
Usage: uppercase [options] [<string>]

Options:

  -h,    --help                Print this message.
  -V,    --version             Print the package version.
```

</section>

<!-- /.usage -->

<section class="examples">

### Examples

```bash
$ uppercase bEEp
BEEP
```

To use as a [standard stream][standard-streams],

```bash
$ echo -n 'bEEp' | uppercase
BEEP
```

</section>

<!-- /.examples -->

</section>

<!-- /.cli -->

<!-- Section for related `stdlib` packages. Do not manually edit this section, as it is automatically populated. -->

<section class="related">

* * *

## See Also

-   <span class="package-name">[`@stdlib/string/capitalize`][@stdlib/string/capitalize]</span><span class="delimiter">: </span><span class="description">capitalize the first character in a string.</span>
-   <span class="package-name">[`@stdlib/string/lowercase`][@stdlib/string/lowercase]</span><span class="delimiter">: </span><span class="description">convert a string to lowercase.</span>

</section>

<!-- /.related -->

<!-- Section for all links. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->


<section class="main-repo" >

* * *

## Notice

This package is part of [stdlib][stdlib], a standard library for JavaScript and Node.js, with an emphasis on numerical and scientific computing. The library provides a collection of robust, high performance libraries for mathematics, statistics, streams, utilities, and more.

For more information on the project, filing bug reports and feature requests, and guidance on how to develop [stdlib][stdlib], see the main project [repository][stdlib].

#### Community

[![Chat][chat-image]][chat-url]

---

## License

See [LICENSE][stdlib-license].


## Copyright

Copyright &copy; 2016-2022. The Stdlib [Authors][stdlib-authors].

</section>

<!-- /.stdlib -->

<!-- Section for all links. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="links">

[npm-image]: http://img.shields.io/npm/v/@stdlib/string-uppercase.svg
[npm-url]: https://npmjs.org/package/@stdlib/string-uppercase

[test-image]: https://github.com/stdlib-js/string-uppercase/actions/workflows/test.yml/badge.svg?branch=v0.0.9
[test-url]: https://github.com/stdlib-js/string-uppercase/actions/workflows/test.yml?query=branch:v0.0.9

[coverage-image]: https://img.shields.io/codecov/c/github/stdlib-js/string-uppercase/main.svg
[coverage-url]: https://codecov.io/github/stdlib-js/string-uppercase?branch=main

<!--

[dependencies-image]: https://img.shields.io/david/stdlib-js/string-uppercase.svg
[dependencies-url]: https://david-dm.org/stdlib-js/string-uppercase/main

-->

[chat-image]: https://img.shields.io/gitter/room/stdlib-js/stdlib.svg
[chat-url]: https://gitter.im/stdlib-js/stdlib/

[stdlib]: https://github.com/stdlib-js/stdlib

[stdlib-authors]: https://github.com/stdlib-js/stdlib/graphs/contributors

[umd]: https://github.com/umdjs/umd
[es-module]: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Modules

[deno-url]: https://github.com/stdlib-js/string-uppercase/tree/deno
[umd-url]: https://github.com/stdlib-js/string-uppercase/tree/umd
[esm-url]: https://github.com/stdlib-js/string-uppercase/tree/esm
[branches-url]: https://github.com/stdlib-js/string-uppercase/blob/main/branches.md

[stdlib-license]: https://raw.githubusercontent.com/stdlib-js/string-uppercase/main/LICENSE

[standard-streams]: https://en.wikipedia.org/wiki/Standard_streams

<!-- <related-links> -->

[@stdlib/string/capitalize]: https://www.npmjs.com/package/@stdlib/string-capitalize

[@stdlib/string/lowercase]: https://www.npmjs.com/package/@stdlib/string-lowercase

<!-- </related-links> -->

</section>

<!-- /.links -->
