"use strict";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var RE2 = require('re2');

var ipRegex = require('ip-regex');

var tlds = require('tlds');
/* istanbul ignore next */


var SafeRegExp = typeof RE2 === 'function' ? RE2 : RegExp;
var ipv4 = ipRegex.v4().source;
var ipv6 = ipRegex.v6().source;

module.exports = function (options) {
  options = _objectSpread({
    exact: false,
    strict: false,
    gmail: true,
    utf8: true,
    localhost: true,
    ipv4: true,
    ipv6: false,
    tlds: tlds,
    returnString: false
  }, options);
  var host = "(?:(?:[a-z\\u00a1-\\uffff0-9][-_]*)*[a-z\\u00a1-\\uffff0-9]+)";
  var domain = "(?:\\.(?:[a-z\\u00a1-\\uffff0-9]-*)*[a-z\\u00a1-\\uffff0-9]+)*"; // Add ability to pass custom list of tlds
  // <https://github.com/kevva/url-regex/pull/66>

  var tld = "(?:\\.".concat(options.strict ? "(?:[a-z\\u00a1-\\uffff]{2,})" : "(?:".concat(options.tlds.sort(function (a, b) {
    return b.length - a.length;
  }).join('|'), ")"), ")"); // <https://github.com/validatorjs/validator.js/blob/master/src/lib/isEmail.js>

  var emailUserPart = options.gmail ? // https://support.google.com/mail/answer/9211434?hl=en#:~:text=Usernames%20can%20contain%20letters%20(a%2Dz,in%20a%20row.
  // cannot contain: &, =, _, ', -, +, comma, brackets, or more than one period in a row
  // note that we are parsing for emails, not enforcing username match, so we allow +
  '[^\\W_](?:[\\w\\.\\+]+)' // NOTE: we don't end with `[^\\W]` here since Gmail doesn't do this in webmail
  : options.utf8 ? "[^\\W_](?:[a-z\\d!#\\$%&'\\*\\+\\-\\/=\\?\\^_`{\\|}~\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]+)" : "[^\\W_](?:[a-z\\d!#\\$%&'\\*\\+\\-\\/=\\?\\^_`{\\|}~]+)";
  var regex = "(?:".concat(emailUserPart, "@(?:");
  if (options.localhost) regex += 'localhost|';
  if (options.ipv4) regex += "".concat(ipv4, "|");
  if (options.ipv6) regex += "".concat(ipv6, "|");
  regex += "".concat(host).concat(domain).concat(tld, "))"); // Add option to return the regex string instead of a RegExp

  if (options.returnString) return regex;
  return options.exact ? new SafeRegExp("(?:^".concat(regex, "$)"), 'i') : new SafeRegExp(regex, 'ig');
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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