# floating-point-regex [![NPM version](https://img.shields.io/npm/v/floating-point-regex.svg?style=flat)](https://www.npmjs.com/package/floating-point-regex) [![NPM monthly downloads](https://img.shields.io/npm/dm/floating-point-regex.svg?style=flat)](https://npmjs.org/package/floating-point-regex)  [![NPM total downloads](https://img.shields.io/npm/dt/floating-point-regex.svg?style=flat)](https://npmjs.org/package/floating-point-regex) [![Linux Build Status](https://img.shields.io/travis/regexhq/floating-point-regex.svg?style=flat&label=Travis)](https://travis-ci.org/regexhq/floating-point-regex)

> Regular expression for matching floating-point literals.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save floating-point-regex
```

## Usage

```js
var regex = require('floating-point-regex');

console.log(regex().test('3.1415926'))   // true
console.log(regex().test('-.123456789')) // true
console.log(regex().test('-3.1E+12'))    // true
console.log(regex().test('-3.1E-12'))    // true
console.log(regex().test('+3.1E-12'))    // true
console.log(regex().test('3.1E-12'))     // true
console.log(regex().test('3.1E12'))      // true
console.log(regex().test('3.1e12'))      // true
console.log(regex().test('0.1e-23'))     // true
console.log(regex().test('.1e-23'))      // true
console.log(regex().test('-2.001'))      // true
console.log(regex().test('2.001'))       // true
console.log(regex().test('2'))           // true
console.log(regex().test('2.0e1'))       // true
```

## About

### Related projects

* [punctuation-regex](https://www.npmjs.com/package/punctuation-regex): Regular expression for matching punctuation characters. | [homepage](https://github.com/regexhq/punctuation-regex "Regular expression for matching punctuation characters.")
* [unc-path-regex](https://www.npmjs.com/package/unc-path-regex): Regular expression for testing if a file path is a windows UNC file path. Can… [more](https://github.com/regexhq/unc-path-regex) | [homepage](https://github.com/regexhq/unc-path-regex "Regular expression for testing if a file path is a windows UNC file path. Can also be used as a component of another regexp via the `.source` property.")
* [whitespace-regex](https://www.npmjs.com/package/whitespace-regex): Regular expression for matching the whitespace in a string. | [homepage](https://github.com/regexps/whitespace-regex "Regular expression for matching the whitespace in a string.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

Please read the [contributing guide](.github/contributing.md) for advice on opening issues, pull requests, and coding standards.

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.4.2, on February 21, 2017._