var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { ok } from "assert";
import fetch from "node-fetch";
import { FETCH_PSL_EXPECTED_MIN_LENGTH, PUBLIC_SUFFIX_URL } from "../config";
export const fetchPsl = () => __awaiter(void 0, void 0, void 0, function* () {
    const response = yield fetch(PUBLIC_SUFFIX_URL);
    const pslContent = yield response.text();
    // Sanity check
    ok(pslContent.length >= FETCH_PSL_EXPECTED_MIN_LENGTH, "Public suffix list is shorter than expected");
    return pslContent;
});
//# sourceMappingURL=fetch-psl.js.map