The **UUE** module is able to perform [uuencoding](http://en.wikipedia.org/wiki/Uuencoding) of a file (or Node.js Buffer) to a text message. This module is also able to find uuencoded files in text messages and decode them.

The module is named after a common `.UUE` suffix for Fidonet echomail areas where uuencoded files are posted (sometimes the results of such encoding are also known as “UUE codes”).

The module is written in JavaScript and requires [Node.js](http://nodejs.org/) to run.
* Starting from v3.0.0, this module requires Node.js version 4.0.0 or newer.
* You may run older versions of this module in Node.js version 0.10.x or 0.12.x. These older versions of this module, however, had to contain an additional dependency ([`array.prototype.findindex`](https://www.npmjs.com/package/array.prototype.findindex)) as a polyfill for a missing [ECMAScript 2015 (ES6) feature](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/findIndex) which is now a part of Node.js. Those older versions of Node.js are themselves not maintained by their developers after 2016-12-31.

## Installing the UUE module

[![(npm package version)](https://nodei.co/npm/uue.png?downloads=true&downloadRank=true)](https://npmjs.org/package/uue) [![(a histogram of downloads)](https://nodei.co/npm-dl/uue.png?months=3&height=3)](https://npmjs.org/package/uue)

* Latest packaged version: `npm install uue`

* Latest githubbed version: `npm install https://github.com/Mithgol/node-uue/tarball/master`

The npm package does not contain the tests, they're published on GitHub only.

You may visit https://github.com/Mithgol/node-uue#readme occasionally to read the latest `README` because the package's version is not planned to grow after changes when they happen in `README` only. (And `npm publish --force` is [forbidden](http://blog.npmjs.org/post/77758351673/no-more-npm-publish-f) nowadays.)

## Using the UUE module

When you `require()` the installed module, you get an object that has the following methods:

### encode(encodeSource, encodeOptions)

Returns a string of UUE codes that represent the given source.

* If `encodeSource` is a string, it is interpreted as a path of some file, and that file is uuencoded.

* If `encodeSource` is a Node.js [Buffer](http://nodejs.org/docs/latest/api/buffer.html), the contents of that buffer become uuencoded.

**Note: ** if a file's name is given to the `.encode` method, a synchronous reading of the given file is performed. If you need an asynchronous reading, perform it yourself and give the resulting Buffer to the `.encode` method.

The optional `encodeOptions` parameter is an object with the following optional properties:

* `mode` — read/write/execute permissions for the file.
   * The `mode` property may be given as a string (of octal digits) or as a number (for example, `'666'` and `438` are equivalent). You may even use [an octal number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Lexical_grammar#Numeric_literals) if your engine supports this ECMAScript 6 feature. (For example, `'644'` and `0o644` are equivalent in Node 4.0.0 or newer.)
   * If this property is omitted, three last octal digits of the `mode` property of the given file's [`fs.Stats`](http://nodejs.org/docs/latest/api/fs.html#fs_class_fs_stats) object are used (or `'644'` if a Buffer is given in `encodeSource` instead of a file).

* `filename` — a file's name to be given in UUE codes. (For example, if `encodeOptions` is `{mode:'664', filename:'filename.ext'}`, then the first line of UUE codes is `begin 664 filename.ext`.) If this property is omitted, then [`path.basename(encodeSource)`](http://nodejs.org/docs/latest/api/path.html#path_path_basename_p_ext) is used (or `'buffer.bin'` if a Buffer is given in `encodeSource` instead of a file).

* `eol` — end-of-line character(s). If this property is omitted, `\n` (`\x0A`) is used (as in Web or UN*X applications). You may want to set `encodeOptions.eol` equal to [`os.EOL`](http://nodejs.org/docs/latest/api/os.html#os_os_eol) on other systems. The value of `encodeOptions.eol` is used only as a separator between lines of UUE codes, but neither in the beginning nor at the end of the returned string.

Example (uuencoding the word `'Cat'`, [as in Wikipedia):](http://en.wikipedia.org/w/index.php?title=Uuencoding&oldid=607304984#Formatting_mechanism)

![(uuencoding example)](https://cloud.githubusercontent.com/assets/1088720/3140039/8953db68-e901-11e3-9759-0ebff59ea331.gif)

### decodeFile(text, filename)

Using the given `filename`, finds the uuencoded file in the given `text`, decodes the file and returns it as a Node.js [Buffer.](http://nodejs.org/docs/latest/api/buffer.html)

Lines in the given `text` are expected to be separated by `'\n'` (`\x0A`).

Invalid UUE codes are ignored entirely (even if only one line of some UUE code block is wrong, that code block is not decoded).

Any UUE codes of any file that has a different filename (i.e. not the given `filename`) are ignored. (In other words, even if `text` contains several uuencoded files, it is not necessary for the file with the given `filename` to be the first of them: files with other names may precede it, and it still will be found and decoded nevertheless.)

If several uuencoded files have the same `filename` (case-sensitive), only the first is returned (its other namesakes are ignored).

If the file cannot be found in the given `text`, `null` is returned.

### decodeAllFiles(text)

Finds all uuencoded files in the given `text`, decodes them and returns as an array.

Entries in the returned array are objects with the following properties:

* `name` — the file's name (as it appeared in UUE codes);

* `data` — a Node.js [Buffer](http://nodejs.org/docs/latest/api/buffer.html) containing the file's decoded contents.

Lines in the given `text` are expected to be separated by `'\n'` (`\x0A`).

Invalid UUE codes are ignored entirely (even if only one line of some UUE code block is wrong, that code block is not decoded).

The returned array contains files in order of their appearance in the given `text`. If several uuencoded files have the same `name` (case-sensitive), only the first file is returned (its other namesakes are ignored).

If the given `text` does not seem to contain any uuencoded files, an empty array (`[]`) is returned.

### split(text)

Finds all uuencoded files in the given `text` and splits that text into an array of text blocks and UUE blocks.

Text blocks of the returned array are JavaScript strings.

UUE blocks of the returned array are objects representing the decoded files. Each object has the following properties:

* `name` — the file's name (as it appeared in UUE codes);

* `data` — a Node.js [Buffer](http://nodejs.org/docs/latest/api/buffer.html) containing the file's decoded contents.

* `source` — a JavaScript string containing source UUE codes of the file from (and including) the beginning `'begin'` to (and including) the final `'end'`.

* `type` — always the JavaScript string `'UUE'`. Might help in further processing of the array (i.e. if other types of blocks are going to be decoded from text blocks; for example, in an [abstract syntax tree](https://github.com/Mithgol/node-abstract-syntax-tree)).

Lines in the given `text` are expected to be separated by `'\n'` (`\x0A`).

Invalid UUE codes are ignored entirely (even if only one line of some UUE code block is wrong, that code block is not decoded and instead is returned as a part of some text block).

The returned array contains blocks in order of their appearance in the given `text`. Unlike `.decodeAllFiles`, even if several uuencoded files have the same `name`, none of them becomes deliberately ignored.

Empty strings (`''`) do not become text blocks of the returned array. (For example, if the given `text` starts with UUE codes, then the first of the returned blocks is a UUE block instead of an empty text block.) This nuance makes this method slightly different from its String's namesake (where `'foo'.split(/(f)/)` returns `['', 'f', 'oo']`) and thus `typeof` has to be used instead of checking whether some element's index is even (or odd).

A line separator `'\n'` (`\x0A`) that immediately precedes or follows a UUE block does not become a part of that block; instead of it such separator becomes a part of an adjacent JavaScript string.

## Locking files

The module **does not** lock any files and **does not** create any “lock files” (flag files, semaphore files). The module's caller should control the access to the file that is being encoded.

## Resolved compatibility issues

* Version 2.1.0 (and newer) accepts UUE codes that use a whitespace (instead of a backtick) on a line that immediately precedes their final `end`.

* Version 3.1.0 (and newer) has no problems decoding files that have whitespaces in the middle of their filenames.

## Testing the UUE module

[![(build testing status)](https://img.shields.io/travis/Mithgol/node-uue/master.svg?style=plastic)](https://travis-ci.org/Mithgol/node-uue)

The tests are not included in the npm package of the module (to keep it small). Use the version from GitHub.

It is necessary to install [Mocha](https://mochajs.org/) and [JSHint](http://jshint.com/) for testing.

* You may install Mocha globally (`npm install mocha -g`) or locally (`npm install mocha` in the directory of the UUE module).

* You may install JSHint globally (`npm install jshint -g`) or locally (`npm install jshint` in the directory of the UUE module).

After that you may run `npm test` (in the directory of the UUE module).

## License

MIT license (see the `LICENSE` file).