import fs from 'fs';
import path from 'path';
import AWS from 'aws-sdk';

import config from '../config';

const { logBucket, accessKey, secretAccessKey } = config.s3;

const s3 = new AWS.S3({
    accessKeyId: accessKey,
    secretAccessKey: secretAccessKey,
})

export default {
    upload_on_s3: async(filename, reportedMailId) => {
            try {
                let location = config.app.type
                if(location == 'staging') location = 'Staging-Mails'
                else if(location == 'inhouse') location ='ReportedMail-Test' 
                else location = 'Mails'

                const filePath = path.join(appRoot, 'Content', 'MailAttachments', filename);
                if (fs.existsSync(filePath)) {
                    const blob = fs.readFileSync(filePath)
                    const uploadedImage = await s3.upload({
                        Bucket: logBucket,
                        Key: `${location}/${reportedMailId}/attachments/${filename}`,
                        Body: blob,
                    }).promise()
                    console.log('file uploaded', filename);

                } else {
                    console.log('file not exists', filename);
                }
            } catch (err) {
                console.log(err);
                console.log('upload file failed');
            }
    },

    uploadReportedMail: async(reportedEmail) => {
        const {_id, header, body, parsedHeader } = reportedEmail 
        if(!config.s3.isSASS){
            try {
                await db.ReportedMail.updateOne({_id},{ header, body, parsedHeader })
                console.log('-----------------------Successfully saved reported mail to db!--------------------', _id);
                return true
            
            } catch (err) {
                console.log(err);
                console.log('Error saving reported mail to db!');
            }
        }
        else{
            try {
                let location = config.app.type
                if(location == 'staging') location = 'Staging-Mails'
                else if(location == 'inhouse') location ='ReportedMail-Test' 
                else location = 'Mails'

                const upload = await s3.upload({
                    Bucket: logBucket,
                    Key: `${location}/${_id}/mail`,
                    Body: JSON.stringify(reportedEmail),
                }).promise()
                console.log('-----------------------Successfully saved reported mail to s3!--------------------', _id);
            
            } catch (err) {
                console.log(err);
                console.log('Error saving reported mail to s3!');
            }
        }
    },

    fetchReportedMail: async(reportedMailId) => {
        const reportedMail =  await db.ReportedMail.findOne({
            _id: reportedMailId,
            deletedAt: null,
        });
        if(reportedMail && reportedMail.isLiteEnvReport) return reportedMail

        if(!config.s3.isSASS){
            try {
                console.log("------------------------------Successfully fetched mail from db!-------------------------------",reportedMailId)
                return reportedMail

            } catch (err) {
                console.log(err);
                console.log('Error fetching reported mail from db');
            }
        }
        else{
            try {
                let location = config.app.type
                if(location == 'staging') location = 'Staging-Mails'
                else if(location == 'inhouse') location ='ReportedMail-Test' 
                else location = 'Mails'

                const res = await s3.getObject({
                    Bucket: logBucket,
                    Key: `${location}/${reportedMailId}/mail`,
                }).promise()

                let mail = JSON.parse(res.Body)

                reportedMail['parsedHeader'] = mail.parsedHeader
                reportedMail['header'] = mail.header
                reportedMail['body'] = mail.body

                console.log("------------------------------Successfully fetched mail from s3!-------------------------------",reportedMailId)
                return reportedMail
            
            } catch (err) {
                console.log(err);
                console.log('Error Fetching Reported Mail from s3!');
            }
        }
    },

    uploadReportedMailAttachments: async(reportedMailId, filePath, fileName,  ContentBytes, ContentType) => {
        if(!config.s3.isSASS){
            try {
                var writeStream = fs.createWriteStream(filePath);
                writeStream.write(Buffer.from(ContentBytes, "base64"))
                console.log("------------------------------Successfully saved mail attachment to db!-------------------------------",reportedMailId)

                return true            
            } catch (err) {
                console.log(err);
                console.log('Error saving Reported Mail Attachment to db');
            } 
        }
        else{
            try {
                console.log(`Uploading attachment ${fileName} for reportedMailId ${reportedMailId} to s3 inside the function`);
                let location = config.app.type
                if(location == 'staging') location = 'Staging-Mails'
                else if(location == 'inhouse') location ='ReportedMail-Test' 
                else location = 'Mails'
                console.log('upload location', `${location}/${reportedMailId}/attachments/${fileName}`);
                const upload = await s3.upload({
                    Bucket: logBucket,
                    Key: `${location}/${reportedMailId}/attachments/${fileName}`,
                    Body:  Buffer.from(ContentBytes,"base64"),
                    ContentType
                }).promise()
                console.log("------------------------------Successfully saved mail attachment to s3!-------------------------------",reportedMailId)
                
                return fileName;
            
            } catch (err) {
                console.log(err);
                console.log('Error saving Reported Mail Attachment to s3');
            }
        }
    },

    fetchReportedMailAttachments: async(reportedMailId, fileName) => {
        console.log("reportedMailId in fetchReportedMailAttachments", reportedMailId, fileName)
        if(!config.s3.isSASS){
            try {
                const filePath = path.join(appRoot, 'Content', 'MailAttachments', fileName);
                if (!fs.existsSync(filePath)) {
                    throw new RequestError('File does not exist');
                }
                let file = fs.createReadStream(filePath)
                console.log("------------------------------Successfully fetched mail attachment from db!-------------------------------",reportedMailId)

                return file
            } catch (err) {
                console.log(err);
                console.log('Error Feteching Reported Mail Attachment from db!');
                return null
            } 
        }
        else{
            try {
                let location = config.app.type
                if(location == 'staging') location = 'Staging-Mails'
                else if(location == 'inhouse') location ='ReportedMail-Test' 
                else location = 'Mails'
                console.log(`location in fetchReportedMailAttachments for s3 ${location}/${reportedMailId}/attachments/${fileName}`)
                const attachment = await s3.getObject({
                    Bucket: logBucket,
                    Key: `${location}/${reportedMailId}/attachments/${fileName}`,
                }).promise()
         
                console.log("------------------------------Successfully fetched mail attachment from s3!-------------------------------",reportedMailId)
                return attachment.Body
                
            } catch (err) {
                console.log('Error Feteching Reported Mail Attachment from s3!');
                console.log(err);
            }
        }
    },
    uploadSiemLogs: async(reportedEmail, companyId) => {
        try {
            if(config.app.type == "production"){
                const {to, from, subject, mailRecievedTime, companyId, internetMessageId, spf, dkim, dmarc, senderIp, header, body, reportedUser, spamScore, resolutionTime, links, attachments } = reportedEmail 
                let location = 'SIEM-Logs'

                const upload = await s3.upload({
                    Bucket: logBucket,
                    Key: `${location}/${companyId}/${internetMessageId}.log`,
                    Body: JSON.stringify(reportedEmail),
                }).promise()
                console.log('\x1b[32m%s\x1b[0m', '-----------------------Successfully looged reported mail to s3!--------------------', companyId);
            
            }
        } catch (err) {
            console.log(err);
            console.log('Error saving reported mail to s3!');
        }
    }
}

