import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { jwtStrategy } from '../../middlewares/strategy';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

const controller = async (req, res, next) => {
  try {
    if (!req.user) {
      return res.status(401).json({ error: "Unauthorized" });
    }

    await req.user.updateOne({
      $set: {
        'security.status': true,
        'security.otpType': 'MAIL',
        'security.otp': null,
        'security.otpExpiry': null
      }
    });

    return res.status(200).json({
      success: true,
      message: 'Two-factor (Mail) enabled successfully'
    });
  } catch (error) {
    console.error('enableMail2FA error:', error);
    return next(error);
  }
};

const apiRouter = express.Router();
apiRouter.route('/').post(htmlsanitize(), jwtStrategy, controller);
export default apiRouter;