import express from 'express';

import userActivity from '../../service/audit-log';
import { sanitize } from '../../middlewares/sanitizer';
import { jwtLogoutStrategy, jwtStrategy } from '../../middlewares/strategy';

let features = [
    {
      name: "Custom Smtp", //done frontend //backend
      description: "Ability to add their custom SMTP to send notification emails.",
      category: "Notifications",
      type: "dynamic",
      featureCode: "TPIR-CSTM"
    },
    {
        name: "Email Alert to SOC Team for threat reports. Threshold configurable", //done frontend backend
        description: "Send alerts to the SOC team when a mail is reported with configurable soc emails.",
        category: "Notifications",
        type: "dynamic",
        featureCode: "TPIR-EASOC"
    },
    {
        name: "Report Notification", //done //backend //
        description: "Notify users when a mail is reported.",
        category: "Notifications",
        type: "dynamic",
        featureCode: "TPIR-RN"
    },
    {
        name: "Notification to user on action taken on email", //done backend //
        description: "Notify users about actions taken on reported emails.",
        category: "Notifications",
        type: "dynamic",
        featureCode: "TPIR-NACT"
    },
    {
        name: "Customisable Email Templates", //done frontend //backend
        description: "Provide customizable templates for notification emails.",
        category: "Notifications",
        type: "dynamic",
        featureCode: "TPIR-CET"
    },
    {
        name: "View Reported Email",   //done frontend //
        description: "Ability to view reported email.",
        category: "Analytics",
        type: "dynamic",
        featureCode: "TPIR-VRE"
    },
    {
      name: "View Reported Email Body",   //done frontend //
      description: "Ability to view reported email.",
      category: "Analytics",
      type: "dynamic",
      featureCode: "TPIR-VREB"
    },
    {
      name: "Header analysis", //done frontend backend
      description: "Analyze email headers for metadata and potential threats.",
      category: "Analytics",
      type: "dynamic",
      featureCode: "TPIR-HA"
    },
    {
      name: "SPF, DKIM, DMARC check-pass", //done backend
      description: "Check and validate SPF, DKIM, and DMARC records to ensure email authenticity.",
      category: "Analytics",
      type: "dynamic",
      featureCode: "TPIR-SDD"
    },
    {
      name: "IP Reputation Check", //done backend //frontend
      description: "Check the reputation of the sending IP address to detect potential spam or malicious sources.",
      category: "Analytics",
      type: "dynamic",
      featureCode: "TPIR-IPRC"
    },
    {
      name: "Sender Domain Reputation Check", //done backend //frontend
      description: "Check the reputation of the sender’s domain to identify potential phishing or spam sources.",
      category: "Analytics",
      type: "dynamic",
      featureCode: "TPIR-SDRC"
    },
    {
      name: "DNS blackhole list", //done frontend //backend
      description: "Check if the sender’s domain or IP address is on a DNS blackhole list.",
      category: "Analytics",
      type: "dynamic",
      featureCode: "TPIR-DBL"
    },
    {
      name: "User Awareness Score (Based on suspicious email reporting)", //done backend
      description: "Calculate a score based on user reports of suspicious emails to evaluate their awareness level.",
      category: "Analytics",
      type: "dynamic",
      featureCode: "TPIR-UAS"
    },
    {
      name: "Download raw email", //done frontend //
      description: "Allow users to download raw email headers for further analysis.",
      category: "Analytics",
      type: "dynamic",
      featureCode: "TPIR-DRH"
    },
    {
      name: "Spam Score to reported email", //done backend frontend
      description: "Assign a spam score to reported emails to help identify potential spam.",
      category: "Scanner",
      type: "dynamic",
      featureCode: "TPIR-SSRE"
    },
    {
      name: "Email content scan", //done 
      description: "Scan email content for potential threats such as phishing or malware.",
      category: "Scanner",
      type: "dynamic",
      featureCode: "TPIR-ECS"
    },
    {
      name: "Advanced Attachment and URL/Link protection", //done frontend backend
      description: "Protect against threats by scanning attachments and URLs/links in emails for malicious content.",
      category: "Scanner",
      type: "dynamic",
      featureCode: "TPIR-AALP"
    },
    {
      name: "View Attachment and URL/Links in reported email", //done backend
      description: "View Attachment and URL/Links in reported email with or without scanner",
      category: "Scanner",
      type: "dynamic",
      featureCode: "TPIR-VAUIR"
    },
    {
      name: "Hash comparison for malware detection", //done
      description: "Perform hash comparison on email attachments to detect known malware signatures.",
      category: "Scanner",
      type: "dynamic",
      featureCode: "TPIR-HCMD"
    },
    {
      name: "Who else (Who all within the organization received the mail)", //done frontend //backend
      description: "Identify other users within the organization who received the same email.",
      category: "Advanced Features",
      type: "dynamic",
      featureCode: "TPIR-WE"
    },
    {
      name: "Action (Restore / Trash / Deletion) of suspicious email for entire organization", //done frontend //backend
      description: "Take action on suspicious emails by restoring, trashing or deleting them across the organization.",
      category: "Advanced Features",
      type: "dynamic",
      featureCode: "TPIR-ARTD"
    },
    {
      name: "Find similar emails in the inbox", //done frontend //backend
      description: "Allow users to see similar emails in their inbox for easy identification of potential threats with same subject.",
      category: "Advanced Features",
      type: "dynamic",
      featureCode: "TPIR-FSEI"
    },
    {
      name: "Advanced search", //done frontend //backend
      description: "Provide an advanced search capability to quickly find specific emails or threats.",
      category: "Advanced Features",
      type: "dynamic",
      featureCode: "TPIR-ADVS"
    },
    {
      name: "Email Broadcast", //done frontend //backend
      description: "Broadcast a notification email to a group or entire organization for important alerts.",
      category: "Advanced Features",
      type: "dynamic",
      featureCode: "TPIR-EB"
    },
    {
      name: "TSAT", //done frontend backend
      description: "Integration with TSAT for tracking and analyzing threat-related metrics.",
      category: "Integrations",
      type: "dynamic",
      featureCode: "TPIR-TSAT"
    },
    {
      name: "WhatsApp", //done frontend backend
      description: "Generate and send reports via WhatsApp for quick notifications and updates.",
      category: "Reporting",
      type: "dynamic",
      featureCode: "TPIR-WA"
    }
  ]
  
  


let controller = async (req, res, next) => {
    try {
        const companies = await db.Company.find({ deletedAt: null });
        const insertFeatures = await db.Feature.insertMany(features)
        const featureIds = insertFeatures.map(feature => feature._id);

        const companyPromises = companies.map(async (company) => {
            const companyId = company._id;
            try {

                let companyUpdate = insertFeatures.map((feature)=>{
                    return db.CompanyFeature.create({ companyId, featureId: feature._id, featureCode: feature.featureCode })
                })

                await Promise.all([
                    companyUpdate
                ]);
            } catch (error) {
                console.error(`Error processing company ${companyId}:`, error);
            }
        });

        await Promise.all(companyPromises);

        res.status(200).send({ message: 'Updates completed successfully' });
    } catch (error) {
        console.error('Error processing companies:', error);
        next(error);
    }

}

const apiRouter = express.Router();
apiRouter.route('/').get( controller);
export default apiRouter;