import express from 'express';
import { jwtStrategy } from '../../middlewares/strategy';



let controller = async (req, res, next) => {
    try {
        const companies = await db.Company.find({ deletedAt: null });

        // Iterate over companies and perform operations
        const companyPromises = companies.map(async (company) => {
            const companyId = company._id;

            try {
                // Parallel updates for Admin and Company
                const adminUpdate = await db.Admin.updateOne(
                    { companyId, deletedAt: null },
                    { $set: { tacIdentityKey: null } }
                );

                const companyUpdate = await db.Company.updateOne(
                    { _id: companyId },
                    { $set: { isTacEnabled: false, tacCompanyId: null, tacLicenseKey: null, isNewCompany: false, packageAccessKey: null, lastModifiedPackageId: null, packageModifiedLocally: false } }
                );

                // Create default metadata in bulk
                const metadata = [
                    { name: 'userLimitMessenger', value: '0', companyId },
                ];
                const metaCreate = await db.MetaData.insertMany(metadata);

                // Create default groups
                const allUsersGroup = await db.Group.create({
                    groupName: 'all-users-tpir',
                    type: 'Admin',
                    companyId,
                    tacIdentityKey: null,
                    groupId: null,
                    tacGroupId: null,
                    emailAccess: false,
                    messengerAccess: false,
                    isDefaultGroup: true,
                    deletedAt: null,
                });

                const activeUsersGroup = await db.Group.create({
                    groupName: 'Active Users',
                    type: 'Admin',
                    companyId,
                    tacIdentityKey: null,
                    groupId: null,
                    tacGroupId: null,
                    emailAccess: true,
                    messengerAccess: false,
                    isDefaultGroup: false,
                    deletedAt: null,
                });

            

                // Bulk updates for users
                const userUpdate = await db.User.updateMany(
                    { companyId, deletedAt: null },
                    { $addToSet: { groups: allUsersGroup._id } }
                );

                const activeUserUpdate = await db.User.updateMany(
                    { companyId, isActive: true, deletedAt: null },
                    { $addToSet: { groups: activeUsersGroup._id } }
                );

                const deleteUsersUpdate = await db.User.deleteMany(
                    { companyId, groups: {$nin: [activeUsersGroup._id]}, deletedAt: null },
                );

                // await Promise.all([
                //     adminUpdate,
                //     companyUpdate,
                //     metaCreate,
                //     userUpdate,
                //     activeUserUpdate,
                //     deleteUsersUpdate
                // ]);
            } catch (error) {
                console.error(`Error processing company ${companyId}:`, error);
            }
        });

        // Execute all company operations
        await Promise.all(companyPromises);

        res.status(200).send({ message: 'Updates completed successfully' });
    } catch (error) {
        console.error('Error processing companies:', error);
        next(error);
    }

}

const apiRouter = express.Router();
apiRouter.route('/').get(controller);
export default apiRouter;