import express from 'express';

import userActivity from '../../service/audit-log';
import { sanitize } from '../../middlewares/sanitizer';
import { jwtLogoutStrategy } from '../../middlewares/strategy';


let controller = async (req, res, next) => {
    if(!req.user.sudoPassword){
    userActivity.create(req, 'Logout');
    }
    if(req.user?.email){
        logger.info(`User ${req.user.email} logged out`, { client: req.user.companyId, request: req, event: 'Logged Out' });
    }
    
    if(req.user.type == 'root') await db.Admin.updateOne({email: req.user.email},{loggedIn: false})
    else await db.Employee.updateOne({email: req.user.email},{loggedIn: false})

    return res.status(200).json({ success: true, message: "successfully Logout" });
}

const apiRouter = express.Router();
apiRouter.route('/').get(controller);
export default apiRouter;