import express from 'express';
import { jwtStrategy } from '../../middlewares/strategy';


const controller = async (req, res, next) => {
    try {
        const companyId = req.user.companyId;
        const company = await db.Company.findOne({
            _id: companyId
        })

        let taStatus = {
            enabled: company.isTacEnabled,
            connecting: company.isTaConnectionInProgess,
            isNewCompany: company.isNewCompany
        }

        return res.status(200).send({ success: true, taStatus })
    } catch (error) {
        console.log('error', error);
        next(error)
    }
}

const apiRouter = express.Router();
apiRouter.route('/').get(jwtStrategy, controller);
export default apiRouter;