import Joi from 'joi';
import express from 'express';

import { sanitize } from '../../middlewares/sanitizer';
import { validateBody } from '../../middlewares/validator';
import { htmlsanitize } from '../../middlewares/sanitizeHtml';

const validator = Joi.object().keys({
	email: Joi.string().email().required()
});

/**
 * @api {post} /api/admin/check-email Check Mail
 * @apiName check-email
 * @apiGroup Authentication
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String}    email     Required email of the User.
 * 
 * @apiSuccess {String} success   true
 * @apiSuccess {String} message   email is valid
 * @apiSuccess {String} companies list of companies
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {
 *      "success":true,
 *      "message":"email is valid",
 *     "companies": [
        {
            "_id": "63ad46cf6b429daa7aa9b697",
            "name": "Kratikal tech pvt ltd"
        },
        {
            "_id": "63ad46cf6b429daa7aa9b697",
            "name": "Kratikal tech pvt ltd",
            "type": "employee"
        }
        ]
 *      }
 * 
 * @apiError (404)  {String} status false
 * @apiError (404)  {String} message Email not found in TPIR database please register through this email and then use.
 * 
 * @apiErrorExample Error-Response:
 *     HTTP/1.1 404 Not Found
 *     {
 *      "success":false,
 *      "messages":["Email not found in TPIR database please register through this email and then use"]
 *      }
 */

const controller = async (req, res, next) => {
    try {    

        const { email } = req.body;
        const employeeCompanyIds = [];
        const user = await db.Admin.findOne({ 
            email,
            deletedAt: null
        });
        const employee = await db.Employee.find({ 
            email,
            deletedAt: null
        });
        if(!user && employee.length == 0){
            throw new RequestError('Invalid email received!', 404)
        }

        let companies=[];

        if(user && user.companyId){
            companies = await db.Company.find({
                _id: user ? user.companyId : '' 
            }, '_id name')
        }
        
        if(employee.length){
            for(let i=0; i<employee.length; i++){
                employeeCompanyIds.push(employee[i].companyId)
            }
        }

        const employeeCompany = await db.Company.find({
            _id: {
                $in: employeeCompanyIds
            }
        }, '_id name')

        for(let i=0; i<employeeCompany.length; i++){
            companies.push({
                _id: employeeCompany[i]._id, 
                name: employeeCompany[i].name, 
                type: 'employee'
            })
        }

        return res.status(200).json({
            success: true,
            message: "email is valid",
            companies
        });
        
    } catch (err) {
        console.log(err);
        next(err);
    }
}
const apiRouter = express.Router();
apiRouter.route('/').post(htmlsanitize(), validateBody(validator), controller);
export default apiRouter;