import express from 'express';

import userActivity from '../../service/audit-log';
import { sanitize } from '../../middlewares/sanitizer';
import { jwtLogoutStrategy } from '../../middlewares/strategy';

/**
 * @api {get} /api/admin/logout Logout
 * @apiName logout
 * @apiGroup Authentication
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccess {String} success   true
 * @apiSuccess {String} message   successfully Logout
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {
 *      "success":true,
 *      "message":"successfully Logout"
 *      }
 * 
 */

let controller = async (req, res, next) => {
    if(!req.user.sudoPassword){
    userActivity.create(req, 'Logout');
    }
    if(req.user?.email){
        logger.info(`User ${req.user.email} logged out`, { client: req.user.companyId, request: req, event: 'Logged Out' });
    }
    
    if(req.user.type == 'root') await db.Admin.updateOne({email: req.user.email},{loggedIn: false})
    else await db.Employee.updateOne({email: req.user.email},{loggedIn: false})

    res.clearCookie('login_token', {
        httpOnly: true,
        secure: true,
        sameSite: 'Strict',
    });

    return res.status(200).json({ success: true, message: "successfully Logout" });
}

const apiRouter = express.Router();
apiRouter.route('/').get(sanitize(), jwtLogoutStrategy, controller);
export default apiRouter;