import express from 'express';
import { jwtStrategy } from '../../middlewares/strategy';

/**
 * @api {post} /api/admin/update-config update-config
 * @apiName update-config
 * @apiGroup Authentication
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody (login) {Object} Configuration       Configuration of User
 * 
 * @apiSuccess (200) {String} success     true
 * @apiSuccess (200) {String} message     Updated Configuration successfully!  
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {
 *      "success":true,
 *      "message": "Updated Configuration successfully!"
 *      }
 * 
 */

let controller = async (req, res, next) => {
    try {
        let config = req.body;
        await db.Company.findOneAndUpdate({
            _id: req.user.companyId
        }, { 
            configuration: config 
        }, { 
            new: true 
        })

        res.status(200).send({ success: true, message: "Updated Configuration successfully!" })
    }
    catch (error) {
        console.log("error", error);
        next(new RequestError(error))
    }
}

const apiRouter = express.Router();
apiRouter.route('/').post(jwtStrategy, controller);
export default apiRouter;